# Copyright (c) 2023
# Copyright holder of the paper "End-to-End Meta-Bayesian Optimisation with Transformer Neural Processes".
# Submitted to NeurIPS 2023 for review.
# All rights reserved.

import pickle
import os

import numpy as np

def get_mip_specs(root_dir):
    dims = 135
    num_dims = list(range(12))
    cat_dims = list(range(12, dims))
    min_points = 232

    num_classes = pickle.load(open(os.path.join(root_dir, "MIP_data/alphabet_num_classes.pkl"), "rb"))
    cat_alphabet = {d: list(range(n)) for d,n in zip(cat_dims, num_classes)}

    train_datasets = [
        os.path.join(root_dir, 'MIP_data/', 'data_cluster1.pkl'),
        os.path.join(root_dir, 'MIP_data/', 'data_cluster2.pkl'),
        os.path.join(root_dir, 'MIP_data/', 'data_cluster3.pkl'),
        os.path.join(root_dir, 'MIP_data/', 'data_cluster4.pkl')
    ]
    valid_datasets = []
    test_datasets = [os.path.join(root_dir, 'MIP_data/', 'data_cluster0.pkl')]

    return dims, num_dims, cat_dims, min_points, cat_alphabet, train_datasets, valid_datasets, test_datasets


def get_cond_mip_specs(root_dir):
    train_gps = [
        os.path.join(root_dir, 'MIP_data/', 'gp_1.pt'),
        os.path.join(root_dir, 'MIP_data/', 'gp_2.pt'),
        os.path.join(root_dir, 'MIP_data/', 'gp_3.pt'),
        os.path.join(root_dir, 'MIP_data/', 'gp_4.pt')
    ]
    valid_gps = []
    test_gps = [os.path.join(root_dir, 'MIP_data/', 'gp_0.pt')]

    return *get_mip_specs(root_dir), train_gps, valid_gps, test_gps
