
HoroSVM Python Implementation 


## Dependencies

[Pymanopt](https://github.com/pymanopt/pymanopt) 

[PyTorch](https://pytorch.org/)

📦HoroSVM
 ┣ 📂data
 ┃ ┣ 📂realnet # real-world networks \[1\] used in [hyperboloid SVM](https://github.com/hhcho/hyplinear/blob/master/README.md) \[2\]
 ┃ ┣ 📂wordnet # WordNet embeddings using [hyperbolic cones](https://github.com/dalab/hyperbolic_cones), worker subtree is included as an example
 ┃ ┣ 📂synthetic # mixture gaussian in hyperbolic space generated using [pvae](https://github.com/emilemathieu/pvae)
 ┣ 📜horosvm.py    # horosvm
 ┣ 📜README.md
 ┣ 📜platt.py
 ┣ 📜run\_worker\_subtree.py  # script for worker subtree classification

## Usage


To see the results of HoroSVM experiments on worker subtree dataset:

```
python run_worker_subtree.py 
```

Outputs will be accuracy and F1 score.

Or prepare a dataset with `X_train`,  `y_train`, `X_test`,  `y_test`.

```
from horosvm import horo_svm

hsvm = horo_svm()
hsvm.fit(X_train,y_train)
hsvm.predict(X_test)
```

\[1\] B.P. Chamberlain, J. Clough, and M.P. Deisenroth. Neural Embeddings of Graphs in Hyperbolic Space. arXiv preprint, arXiv:1705.10359, 2017.

\[2\] Cho, Hyunghoon, et al. "Large-margin classification in hyperbolic space." The 22nd international conference on artificial intelligence and statistics. PMLR, 2019.
