# Code for Collaborative Machine Learning with Private Valuation and Rewards

## Set up environment using conda

Tested OS platform: Windows 10, Ubuntu 20.04

`conda env create -f environment.yml`

`conda activate privatecml`


The experiments are performed on a machine with Ubuntu 20.04 LTS, 2 x Intel Xeon Gold 6230 (2.1GHz) without GPU.
The software environments used are miniconda and Python. A full list of packages used is given in `environment.yml`

## Preprocessing dataset
The given processed data in `syn.pkl`, `cali6.pkl` and `diab.pkl` can be generated using `generate_data.py`.
Note that in `syn.pkl` and `diab.pkl`, party 0 and 2 are swapped as compared to the paper (0 has the most data)

## Reward control experiment
The reward control experiment can be run with:

`python reward_control_linreg.py -s syn.pkl -d ind`

`python reward_control_linreg.py -s cali6.pkl -d share`

`python reward_control_logreg.py -s diab.pkl`

To speed up computation, the number of MCMC chains to run can be controlled with the `-c` flag.
The results, such as the KL and loss, are pickled.

## Privacy monotonicity experiment
The privacy monotonicity experiment can be run with:
`python privacy_mono_linreg.py -s syn.pkl -d ind`

`python privacy_mono_linreg.py -s cali6.pkl -d share`

`python privacy_mono_logreg.py -s diab.pkl`

By default, rho in rho-Shapley fair is set to 0.2 and can be controlled using `-p`.
To speed up computation, the number of MCMC chains to run can be controlled with the `-c` flag.
Add the flag `-r` to solve for the rewarded posterior sample and evaluate its losses. The results, such as the KL and loss, are pickled.

## Acknowledgements
We adapted code for noise-aware inference from the papers [Differentially Private Bayesian Linear Regression](https://github.com/gbernstein6/private_bayesian_regression) and Local Differentialy Private Bayesian Inference.
