function[f_vec2,g_vec2,time_vec2,sample_vec, y_bar,acc_vec] = Alg_Projection_Sto(fun_f,grad_f,grad_g,fun_g,TSA,param,x0, A1, A2, b1, b2)
% The update rule is given by: 
% 
% x_{k+1} = \Pi_{\mathcal{Z}}(x_k - \gamma_k(\nabla g(x_k)+\eta_k \nabla f(x_k)))
% 
% We choose \gamma_k = \gamma_0/sqrt{k+1} and \eta_k = \eta_0/(k+1)^0.25

eta_0 = param.eta;
gamma_0 = param.gamma;
lambda=param.lam;

f_vec2 = [];
g_vec2 = [];
time_vec2 = [];
acc_vec = [];
sample_vec = [];
x = x0;

%% algorithm
maxiter = param.maxiter;
maxtime = param.maxtime;
n1 = height(A1);
n2 = height(A2);
S = 0;
S_next = 0;
y_bar = x0;
y_bar_next = x0;
tic;
for k = 1 : maxiter 
    eta_k = (eta_0)*(k+1)^0.25;
    gamma_k = gamma_0/(k+1)^0.75;
    % Uniformly sample
    upperidx1 = randsample(n1,1);
    upperidx2 = randsample(n1,1);
    loweridx1 = randsample(n2,1);
    loweridx2 = randsample(n2,1);
    grad_f1= @(x) (n1)*A1(upperidx1,:)'*(A1(upperidx1,:)*x-b1(upperidx1,:));
    grad_f2= @(x) (n1)*A1(upperidx2,:)'*(A1(upperidx2,:)*x-b1(upperidx2,:));
    grad_g1= @(x) (n2)*A2(loweridx1,:)'*(A2(loweridx1,:)*x-b2(loweridx1,:));
    grad_g2= @(x) (n2)*A2(loweridx2,:)'*(A2(loweridx2,:)*x-b2(loweridx2,:));
    % Descent step
    y = x - gamma_k*(eta_k*grad_g1(x)+(grad_f1(x)));
    y = ProjectOntoL1Ball(y,lambda);
    x = x - gamma_k*(eta_k*grad_g2(y)+(grad_f2(y)));
    x = ProjectOntoL1Ball(x,lambda);
    S_next = S+(gamma_k*eta_k)^0.5;
    y_bar = (S*y_bar+(gamma_k*eta_k)^0.5*y)/S_next;
    S = S_next;
    cpu_t2 = toc;
    f_vec2 = [f_vec2;fun_f(y_bar)];
    g_vec2 = [g_vec2;fun_g(y_bar)];
    time_vec2 = [time_vec2;cpu_t2];
    sample_vec = [sample_vec;k*4];
    % test set accuracy
    acc_vec = [acc_vec;TSA(y_bar)];
%     if cpu_t2>maxtime
%         break
%     end
end