# load npy
import numpy as np
function = 'hang'
energy_1 = np.load('energy_list_clean'+ function+'.npy', allow_pickle=True)
energy_2 = np.load('energy_list_attack'+ function+'.npy', allow_pickle=True)

print("energy_1: ", energy_1)
print("energy_2: ", energy_2)

# plot energy_1 and energy_2
import matplotlib.pyplot as plt
x_range = range(0,10)
# set y axis range
plt.ylim(1000, 1500)
plt.plot(energy_1, label='clean',color = 'tab:green')
plt.plot(energy_2, label='attacked',color = 'tab:red')
# set name of each line
plt.legend()
# set x-axis label
plt.xlabel('time step')
# set y-axis label
plt.ylabel('energy')
plt.show()