import os
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--postfix', type=str, required=True)
parser.add_argument('--debug', action='store_true')


if __name__ == '__main__':
    args = parser.parse_args()

    objs = os.listdir('plenoxels/data/dnerf/')
    print(objs)

    for obj in objs:
        print(obj)
        if args.debug:
            os.system(f"PYTHONPATH='.' python3 -m pdb plenoxels/main.py "
                      f"--config-path=plenoxels/configs/final/D-NeRF/{obj}_hybrid_{args.postfix}.py")
            assert False
        else:
            os.system(f"PYTHONPATH='.' python3 plenoxels/main.py "
                      f"--config-path=plenoxels/configs/final/D-NeRF/{obj}_hybrid_{args.postfix}.py")

        downsamples = [4., 8.]
        for ds in downsamples:
            os.system(f"PYTHONPATH='.' python3 plenoxels/main.py "
                      f"--validate-only "
                      f"--config-path=plenoxels/configs/final/D-NeRF/{obj}_hybrid_{args.postfix}.py "
                      f"--log-dir=logs/syntheticdynamic/{obj}_hybrid_{args.postfix}/ "
                      f"data_downsample={ds}")

