"""Default Hyperparameter configuration."""

import ml_collections


def d(**kwargs):
  """Helper of creating a config dict."""
  return ml_collections.ConfigDict(initial_dictionary=kwargs)


seed = 0


data_dim = 2
def get_config():
  """Get the default hyperparameter configuration."""
  config = ml_collections.ConfigDict()
  config.train_data_config = d(
    seed=seed,
    data_spec="sphere",
    data_dim=data_dim,
    batchsize=100000,
    gaussian_noise_var=0.1,
    fixed_batch=True  # Use one batch from the empirical distribution.
  )
  # config.eval_data_config = dict(reuse_train=True)
  config.eval_data_config = d(  # Use stochastic batches for eval.
    seed=seed,
    data_spec="sphere",
    data_dim=data_dim,
    batchsize=100000,
    gaussian_noise_var=0.1,
    fixed_batch=False,
  )
  config.train_eval_config = d(
    num_train_steps=10000,
    num_eval_steps=1,
    log_metrics_every_steps=10,
    log_imgs_every_steps=100,
    checkpoint_every_steps=int(1e9),
    eval_every_steps=100,
    seed=seed,
    # warm_start="",
  )

  config.model_config = d(
    # rd_lambda=2.0,
    rd_lambda=10.0,
    latent_dim=2,
    data_dim=config.train_data_config.data_dim,
    distort_type='half_sse',
    scheduled_num_steps=config.train_eval_config.num_train_steps,
    transform_config=d(
      encoder_units=[20, 20],
      decoder_units=[20, 20],
      encoder_activation='relu',
      decoder_activation='relu',
      posterior_type='gaussian',
      prior_type='maf',
      ar_hidden_units=[10, 10],
      ar_activation='relu',
      maf_stacks=2,
      iaf_stacks=0
    ),
    optimizer_config=d(
      name='adam',
      # name='sgd',
      # lr_decay=True,
      # lr_decay_rate=1e-3,
      warmup_steps=0,  # No warmup
      reduce_lr_after=1.0,  # No lr decay
      learning_rate=1e-3,
      # clip_norm=1.0,
    )
  )
  config.ckpt_restore_dir = 'None'
  return config


def get_cfg_str(config):
  from collections import OrderedDict
  runname_dict = OrderedDict()
  runname_dict['ldim'] = config.model_config.latent_dim
  runname_dict['rd_lambda'] = config.model_config.rd_lambda
  runname_dict['tseed'] = config.train_eval_config.seed

  from common import utils
  return utils.config_dict_to_str(runname_dict, skip_falsy=False)


def get_hyper():
  """
  Produce a list of flattened dicts, each containing a hparam configuration overriding the one in
  get_config(), corresponding to one hparam trial/experiment/work unit.
  :return:
  """
  from common import hyper
  # gaussian_noise_vars = [0.1, 1]
  # gaussian_noise_vars = [0.1]
  # gaussian_noise_vars = hyper.sweep("train_data_config.gaussian_noise_var",
  #                                   gaussian_noise_vars)
  # ldims = hyper.sweep("model_config.latent_dim",
  #                                [2, 3, 4])
  # rd_lambdas = [0.01, 0.03, 0.1, 0.3, 1., 3., 10.]
  rd_lambdas = [300, 100, 30, 10, 3, 1]
  rd_lambdas = hyper.sweep('model_config.rd_lambda', rd_lambdas)
  tseeds = hyper.sweep('train_eval_config.seed', list(range(5)))

  hparam_cfgs = hyper.product(rd_lambdas, tseeds)
  return hparam_cfgs
