# NeurIPS'23 submission (#7782)

This repo contains the code to compute the decomposition proposed in the paper, either in the ambient euclidean space, or the tangent space to the VL sphere's intrinsic mean.

## install

First, please install the necessary dependencies:

```bash
pip install -r requirements.txt
```

## usage

One can compute the decomposition as follows (using the default 4 parts of speech):

```python
from model import Model
M = Model(root_dir='../')

M.load_vocab(M.categories, root_dir=M.root_dir)
M.encode_vocab(M.categories)
```

And then learn the subspace of the ambient euclidean space with:

```python
lam = 0.5
e = {'N': M.E['N'][:n].clone(), 'V': M.E['V'][:n].clone(), 'AV': M.E['AV'][:n].clone(), 'A': M.E['A'][:n].clone()}

# get the subspace, and the mean:
W, m = M.decompose(categories=['N', 'A', 'V', 'AV'], encodings=e, lam=lam)
```

Or in the tangent space with:

```python
lamt = 0.5
en = {'N': M.E['N'][:n].clone(), 'V': M.E['V'][:n].clone(), 'AV': M.E['AV'][:n].clone(), 'A': M.E['A'][:n].clone()}
Wt, mt = M.decompose_tangent(categories=['N', 'A', 'V', 'AV'], encodings=en, lam=lamt)
```