;; gorilla-repl.fileformat = 1

;; @@

(ns model
  (:require [gorilla-plot.core :as plot])
  (:use [anglican core emit runtime stat
          [state :only [get-predicts get-log-weight get-result]]]))

(defdist geometric
"Geometric distribution on support {0,1,2....}"
[p] []
(sample* [this]
        (loop [value 0]
            (if (sample* (flip p))
            value
            (recur (inc value)))))
(observe* [this value] (+ (log p) (* value (log (- 1 p))))))

(defdist dirac [x]
    (sample* [this] x)
    (observe* [this value]
              (if (= value x)
                0
                (- (/ 1.0 0.0)))))


(with-primitive-procedures [dirac geometric]
  (defquery model [method- options- ]
    (let [[ a b] [ 0 0 ]
          [ a b]
          (let [
                a (sample (poisson 4.626))
                b (sample (poisson 0.514))
                b (+ b (sample (binomial a 0.1)))
                a (sample (binomial a 0.23724))
                b (sample (binomial b 0.2636))
                a (+ a (sample (poisson 20.934)))
                b (+ b (sample (poisson 2.3260000000000005)))
                _unused (observe (binomial a 0.2) 3)
                _unused (observe (binomial b 0.2) 1)
                b (+ b (sample (binomial a 0.1)))
                a (sample (binomial a 0.23724))
                b (sample (binomial b 0.2636))
                a (+ a (sample (poisson 37.872)))
                b (+ b (sample (poisson 4.208)))
                _unused (observe (binomial a 0.2) 11)
                _unused (observe (binomial b 0.2) 2)
                b (+ b (sample (binomial a 0.1)))
                a (sample (binomial a 0.23724))
                b (sample (binomial b 0.2636))
                a (+ a (sample (poisson 27.072000000000003)))
                b (+ b (sample (poisson 3.0080000000000005)))
                _unused (observe (binomial a 0.2) 9)
                _unused (observe (binomial b 0.2) 1)
                b (+ b (sample (binomial a 0.1)))
                a (sample (binomial a 0.23724))
                b (sample (binomial b 0.2636))
                a (+ a (sample (poisson 27.072000000000003)))
                b (+ b (sample (poisson 0.856)))
                _unused (observe (binomial a 0.2) 5)
                _unused (observe (binomial b 0.2) 0)
               ]
            [ a b ]
          )
         ]
    b
    )
  )

)


(def model_name "two_populations200")
(def outfile "two_populations200_anglican.json")

; (def configurations [:rmh []])
(def configurations
  [
    [:importance []]
    [:lmh []]
    [:rmh []]
    [:smc []]
    [:smc [:number-of-particles 100]]
    [:pgibbs []]
    [:ipmcmc []]
  ])

; (def num_samples_options [1000])
(def num_samples_options [1000 10000])
(def thinning 1)

(spit outfile "[\n" :append false)

(def num-chains 20)

(doall
  (for [ num_samples num_samples_options
         [method options] configurations
         chain (range 0 num-chains)]
    (do
      (println (format "\nMethod %s with %s samples and options %s" method num_samples options))
      (println (format "Chain no. %s" chain))
      (let [start (. System (nanoTime))
            warmup (/ num_samples 5)
            samples (take-nth thinning (take (* num_samples thinning) (drop warmup (apply doquery method model [method options] options))))
            results (collect-results samples)
            values (map (fn [s] (get-result s)) samples)
            max-value (apply max values)
            mean (empirical-mean results)
            variance (empirical-variance results)
            std (empirical-std results)
            skewness (if (zero? std) (/ 0.0 0.0) (empirical-skew results))
            kurtosis (if (zero? std) (/ 0.0 0.0) (empirical-kurtosis results))
            distribution (empirical-distribution (collect-results samples))
            masses (for [n (range 0 (inc max-value))] (get distribution n 0.0))
            end (. System (nanoTime))
            elapsed_ms (/ (- end start) 1e6)]
        (println (format "Elapsed time: %s ms" elapsed_ms))
        (println (format "Empirical mean: %s" mean))
        (println (format "Empirical variance: %s" variance))
        (println (format "Empirical std: %s" std))
        (println (format "Empirical skewness: %s" skewness))
        (println (format "Empirical kurtosis: %s" kurtosis))
        (spit outfile (format
                   "{\"model\": \"%s\", \"system\": \"anglican\", \"method\": \"%s\", \"options\": \"%s\", \"num_samples\": %s, \"time_ms\": %s, \"total\": 1.0, \"mean\": %s, \"variance\": %s, \"stddev\": %s, \"skewness\": %s, \"kurtosis\": %s, \"masses\": [%s] },\n"
                   model_name method options num_samples elapsed_ms mean variance std skewness kurtosis
                   (clojure.string/join ", " masses)) :append true)
        (if false (do
          (println "Empirical distribution:")
          (doall (for [n (range 0 (inc max-value))]
            (println (format "p(%s) = %s" n (get distribution n 0.0)))))))
        ; (println "List of samples (format: sample log-weight):")
        ; (doall (map (fn [s] (println (format "%s %s" (get-result s) (get-log-weight s)))) samples))
        ; values need to be adjusted if they are weighted!
        ; (plot/histogram values :normalize :probability)
      )
    )
  )
)

(spit outfile "]\n" :append true)




;; @@
;; ->
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 225.387014 ms
;;; Empirical mean: 2.752324527859515
;;; Empirical variance: 2.86503978876475
;;; Empirical std: 1.6926428414656027
;;; Empirical skewness: 0.5824577598771742
;;; Empirical kurtosis: 3.394498296930293
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 168.931963 ms
;;; Empirical mean: 2.680739665979533
;;; Empirical variance: 2.4122836153774494
;;; Empirical std: 1.553152798464288
;;; Empirical skewness: 0.6058178583906594
;;; Empirical kurtosis: 3.358894044649091
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 175.784869 ms
;;; Empirical mean: 2.7139326076124988
;;; Empirical variance: 2.4831687432620893
;;; Empirical std: 1.5758073306283638
;;; Empirical skewness: 0.5097393160179527
;;; Empirical kurtosis: 3.3057477711176206
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 195.623834 ms
;;; Empirical mean: 2.7649189307505293
;;; Empirical variance: 2.8462399753036984
;;; Empirical std: 1.687080310863623
;;; Empirical skewness: 0.6153864173939044
;;; Empirical kurtosis: 3.2220493889572372
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 174.942478 ms
;;; Empirical mean: 2.600455078319117
;;; Empirical variance: 2.589221753137494
;;; Empirical std: 1.60910588624164
;;; Empirical skewness: 0.6313877999864713
;;; Empirical kurtosis: 3.316116532804208
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 190.499176 ms
;;; Empirical mean: 2.756796140306257
;;; Empirical variance: 2.522533949990404
;;; Empirical std: 1.588248705332513
;;; Empirical skewness: 0.5932002557538113
;;; Empirical kurtosis: 3.5612244061368514
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 173.386772 ms
;;; Empirical mean: 2.6125413931312145
;;; Empirical variance: 2.87685224348915
;;; Empirical std: 1.696128604643277
;;; Empirical skewness: 0.6224438812913974
;;; Empirical kurtosis: 3.2775865396077712
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 172.921413 ms
;;; Empirical mean: 2.8062615047100827
;;; Empirical variance: 2.5641147724661506
;;; Empirical std: 1.601285350106642
;;; Empirical skewness: 0.5475151943224493
;;; Empirical kurtosis: 3.438275618760735
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 168.752235 ms
;;; Empirical mean: 2.6802984150650038
;;; Empirical variance: 2.6348907403633155
;;; Empirical std: 1.6232346535123365
;;; Empirical skewness: 0.6513732041106642
;;; Empirical kurtosis: 3.4540035367835715
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 167.130218 ms
;;; Empirical mean: 2.7620348355679565
;;; Empirical variance: 2.697792655401682
;;; Empirical std: 1.6424958616086927
;;; Empirical skewness: 0.5381625938096266
;;; Empirical kurtosis: 3.6038772293064203
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 163.328731 ms
;;; Empirical mean: 2.757006932675911
;;; Empirical variance: 2.909085670069981
;;; Empirical std: 1.7056041950200465
;;; Empirical skewness: 0.6563586042399847
;;; Empirical kurtosis: 3.393554764914863
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 163.07966 ms
;;; Empirical mean: 2.7679057339658506
;;; Empirical variance: 2.8295720324193043
;;; Empirical std: 1.6821331791565448
;;; Empirical skewness: 0.527347032518335
;;; Empirical kurtosis: 3.059774433238397
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 162.602528 ms
;;; Empirical mean: 2.712909463994444
;;; Empirical variance: 2.9384170007266324
;;; Empirical std: 1.7141811458322112
;;; Empirical skewness: 0.6306399214173964
;;; Empirical kurtosis: 3.4704452028652115
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 161.75599 ms
;;; Empirical mean: 2.5649535394287355
;;; Empirical variance: 2.585589762845346
;;; Empirical std: 1.6079769161419408
;;; Empirical skewness: 0.7335517222861415
;;; Empirical kurtosis: 3.793174008217093
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 160.629125 ms
;;; Empirical mean: 2.8733089012366286
;;; Empirical variance: 2.998813677140742
;;; Empirical std: 1.7317083117952463
;;; Empirical skewness: 0.57786009832689
;;; Empirical kurtosis: 3.162032096209962
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 166.185419 ms
;;; Empirical mean: 2.7570747660057604
;;; Empirical variance: 2.897080303250823
;;; Empirical std: 1.7020811682322388
;;; Empirical skewness: 0.41980295360522296
;;; Empirical kurtosis: 2.8482266013720916
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 170.75057 ms
;;; Empirical mean: 2.7134320932534237
;;; Empirical variance: 2.836449726270289
;;; Empirical std: 1.6841762752961131
;;; Empirical skewness: 0.587391599441458
;;; Empirical kurtosis: 3.179253666439894
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 167.780513 ms
;;; Empirical mean: 2.712008624885553
;;; Empirical variance: 2.7776195377614052
;;; Empirical std: 1.6666191939856583
;;; Empirical skewness: 0.6222234434283809
;;; Empirical kurtosis: 3.4014938856922576
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 162.048312 ms
;;; Empirical mean: 2.7655672391574635
;;; Empirical variance: 2.655628644815983
;;; Empirical std: 1.629609967082916
;;; Empirical skewness: 0.49359394574358056
;;; Empirical kurtosis: 3.096164658496429
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 168.998394 ms
;;; Empirical mean: 2.6681668400968293
;;; Empirical variance: 2.6033312554832615
;;; Empirical std: 1.6134841974693341
;;; Empirical skewness: 0.5334906124019354
;;; Empirical kurtosis: 3.182675564322217
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 230.035842 ms
;;; Empirical mean: 2.379000000000001
;;; Empirical variance: 1.7713590000000021
;;; Empirical std: 1.3309241150418765
;;; Empirical skewness: 1.0216243937116005
;;; Empirical kurtosis: 4.923460597740083
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 224.752965 ms
;;; Empirical mean: 2.9400000000000004
;;; Empirical variance: 3.3444000000000016
;;; Empirical std: 1.8287700784953809
;;; Empirical skewness: 0.60662588145947
;;; Empirical kurtosis: 3.168364946568994
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 225.913718 ms
;;; Empirical mean: 2.5090000000000012
;;; Empirical variance: 3.107919000000003
;;; Empirical std: 1.7629290967024178
;;; Empirical skewness: 1.395013413436162
;;; Empirical kurtosis: 4.273128024240662
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 234.268713 ms
;;; Empirical mean: 2.736000000000001
;;; Empirical variance: 2.4083040000000024
;;; Empirical std: 1.551871128670162
;;; Empirical skewness: 0.34189121388892996
;;; Empirical kurtosis: 2.7902724127452494
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 230.871353 ms
;;; Empirical mean: 2.150000000000001
;;; Empirical variance: 2.5075000000000007
;;; Empirical std: 1.5835087622113118
;;; Empirical skewness: 0.567224763943929
;;; Empirical kurtosis: 2.54401401975529
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 226.995425 ms
;;; Empirical mean: 2.6010000000000004
;;; Empirical variance: 2.135799000000001
;;; Empirical std: 1.461437306216042
;;; Empirical skewness: -0.005423125280789525
;;; Empirical kurtosis: 2.109442315922189
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 237.77686 ms
;;; Empirical mean: 2.875
;;; Empirical variance: 2.3273750000000017
;;; Empirical std: 1.5255736625938459
;;; Empirical skewness: -0.05922444540741429
;;; Empirical kurtosis: 2.441982455326941
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 228.903685 ms
;;; Empirical mean: 2.665000000000001
;;; Empirical variance: 3.6947750000000017
;;; Empirical std: 1.9221797522604387
;;; Empirical skewness: 0.7040029537100309
;;; Empirical kurtosis: 3.3097297619927923
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 229.777366 ms
;;; Empirical mean: 2.947
;;; Empirical variance: 2.7381910000000014
;;; Empirical std: 1.6547480170708775
;;; Empirical skewness: -0.009595806498027333
;;; Empirical kurtosis: 2.2387729085813435
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 255.332441 ms
;;; Empirical mean: 3.535
;;; Empirical variance: 2.472775000000001
;;; Empirical std: 1.5725059618328958
;;; Empirical skewness: -0.12471134314922598
;;; Empirical kurtosis: 2.3681313631172665
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 258.807984 ms
;;; Empirical mean: 3.963000000000001
;;; Empirical variance: 4.887631000000003
;;; Empirical std: 2.210798724443273
;;; Empirical skewness: 0.7914047084789705
;;; Empirical kurtosis: 3.619017680681647
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 263.876972 ms
;;; Empirical mean: 2.3480000000000003
;;; Empirical variance: 2.7328960000000007
;;; Empirical std: 1.65314730136186
;;; Empirical skewness: 0.4733885253620928
;;; Empirical kurtosis: 3.187755949672238
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 244.821615 ms
;;; Empirical mean: 2.698000000000001
;;; Empirical variance: 4.352796000000004
;;; Empirical std: 2.08633554348288
;;; Empirical skewness: 1.4214974257978679
;;; Empirical kurtosis: 4.579552311802113
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 232.696129 ms
;;; Empirical mean: 3.2880000000000003
;;; Empirical variance: 2.6350560000000023
;;; Empirical std: 1.6232855571340497
;;; Empirical skewness: 0.3977660525527138
;;; Empirical kurtosis: 3.1770207674762037
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 227.58755 ms
;;; Empirical mean: 2.5460000000000003
;;; Empirical variance: 2.2198840000000017
;;; Empirical std: 1.4899275150154123
;;; Empirical skewness: 0.2790833229254279
;;; Empirical kurtosis: 2.8577105909506932
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 233.435662 ms
;;; Empirical mean: 2.687000000000001
;;; Empirical variance: 4.471031000000001
;;; Empirical std: 2.114481260262195
;;; Empirical skewness: 0.47514327993730204
;;; Empirical kurtosis: 1.8162576140114606
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 223.168641 ms
;;; Empirical mean: 2.436
;;; Empirical variance: 1.9339040000000016
;;; Empirical std: 1.3906487694597804
;;; Empirical skewness: 0.5181755947237352
;;; Empirical kurtosis: 3.1592936772431632
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 241.915532 ms
;;; Empirical mean: 2.237
;;; Empirical variance: 2.2728310000000014
;;; Empirical std: 1.507591124940712
;;; Empirical skewness: 0.36588506144611
;;; Empirical kurtosis: 2.1137945125848083
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 231.908238 ms
;;; Empirical mean: 3.144000000000001
;;; Empirical variance: 3.7872640000000035
;;; Empirical std: 1.9460894121288477
;;; Empirical skewness: 1.2201470261692406
;;; Empirical kurtosis: 4.001044368344685
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 228.965552 ms
;;; Empirical mean: 3.575
;;; Empirical variance: 3.014375000000002
;;; Empirical std: 1.736195553501967
;;; Empirical skewness: 0.5245190453435334
;;; Empirical kurtosis: 3.406190807068674
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 310.526894 ms
;;; Empirical mean: 2.4650000000000007
;;; Empirical variance: 3.4967750000000013
;;; Empirical std: 1.8699665772414227
;;; Empirical skewness: 0.6723586947309304
;;; Empirical kurtosis: 2.505537734965996
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 333.329809 ms
;;; Empirical mean: 2.3120000000000003
;;; Empirical variance: 2.0646560000000016
;;; Empirical std: 1.4368910884266775
;;; Empirical skewness: 0.5862132929134001
;;; Empirical kurtosis: 3.4766368381287016
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 332.333624 ms
;;; Empirical mean: 2.2490000000000006
;;; Empirical variance: 1.2109990000000008
;;; Empirical std: 1.1004539972211473
;;; Empirical skewness: 0.7480932561939747
;;; Empirical kurtosis: 2.9905514541623517
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 3
;;; 
;; <-
;; =>
;;; {"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x4369e02b]</span>","value":"#multifn[print-method 0x4369e02b]"}],"value":"[nil,#multifn[print-method 0x4369e02b]]"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x4369e02b]</span>","value":"#multifn[print-method 0x4369e02b]"}],"value":"[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model</span>","value":"#'model/model"}],"value":"[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model_name</span>","value":"#'model/model_name"}],"value":"[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/outfile</span>","value":"#'model/outfile"}],"value":"[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/configurations</span>","value":"#'model/configurations"}],"value":"[[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num_samples_options</span>","value":"#'model/num_samples_options"}],"value":"[[[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/thinning</span>","value":"#'model/thinning"}],"value":"[[[[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num-chains</span>","value":"#'model/num-chains"}],"value":"[[[[[[[[[[nil,#multifn[print-method 0x4369e02b]],#multifn[print-method 0x4369e02b]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil],#'model/num-chains]"}
;; <=

;; @@

;; @@
