#include <iostream> 
#include <vector>
#include <cmath>
#include <chrono>
#include <random>
#include <fstream>
#include <utility>

#include "hnsw/Index.h"
//#include "cnpy.h"
#include <algorithm>
#include <string>


int main(int argc, char **argv){

    if (argc < 6){
        std::clog<<"Usage: "<<std::endl; 
        std::clog<<"construct <data> <N> <M> <ef_construction> <outfile>"<<std::endl;
		std::clog<<"\t <data> bvecs sift file"<<std::endl;
		std::clog<<"\t <N> int, number of vectors to include from SIFT1B"<<std::endl;
        std::clog<<"\t <M>: int "<<std::endl;
        std::clog<<"\t <ef_construction>: int "<<std::endl;
        std::clog<<"\t <outfile>: where to stash the index"<<std::endl;
        return -1;
    }

//	int space_ID = std::stoi(argv[1]);
	// cnpy::NpyArray datafile = cnpy::npy_load(argv[2]);
	int M = std::stoi(argv[3]);
    int ef_construction = std::stoi(argv[4]);
	int dim = 128;
    int N = std::stoi(argv[2]);

	std::ifstream input(argv[1], std::ios::binary);

    // random level assignments
    int* level_assignments = new int[N];
    std::vector<size_t> level_populations;
    std::default_random_engine level_generator;

    double mult_ = 1 / std::log(1.0 * M);
    for (int i = 0; i < N; i++){
        std::uniform_real_distribution<double> distribution(0.0, 1.0);
        double r = -std::log(distribution(level_generator)) * mult_;
        int level = (int) r;
        level_assignments[i] = level;
        while (level_populations.size() < level+1){
            level_populations.push_back(0);
        }
        for (int j = 0; j <= level; j++){
            level_populations[j]++;
        }
    }

    for (int j = level_populations.size() -1; j >=0 ; j--){
        std::clog<<"levels["<<j<<"] = "<<level_populations[j]<<std::endl;
    }

	L2SpaceI space(dim);
    HNSW<int, int> index(&space, level_populations, M);

    auto start = std::chrono::high_resolution_clock::now();

	unsigned char *element = new unsigned char[dim];
    for (int label = 0; label < N; label++) {
		
		int dim_check;
		input.read((char*)&dim_check, 4); 
		if (dim_check != dim){std::cerr<<"File error"<<std::endl; return -1; }

		input.read((char*) element, dim);
        index.add((void*) element, label, level_assignments[label], ef_construction);
 if (label%100000==0) std::clog<<"."<<std::flush;
    }
    std::clog<<std::endl;
	delete[] element;
	input.close();

    auto stop = std::chrono::high_resolution_clock::now();
    auto duration = std::chrono::duration_cast<std::chrono::milliseconds>(stop - start);
    std::clog << "Build time: " << (float)(duration.count())/(1000.0) << " seconds" << std::endl; 

	std::clog << "Saving index to: " << argv[5] << std::endl;
	std::string filename(argv[5]);
	index.save(filename);

    return 0;
}
