#include <iostream> 
#include <vector>
#include <cmath>
#include <chrono>
#include <random>
#include <fstream>
#include <utility>

#include "hnsw/Index.h"
#include "cnpy.h"
#include <algorithm>
#include <string>


int main(int argc, char **argv){

    if (argc < 4){
        std::clog<<"Usage: "<<std::endl;
        std::clog<<"dump <space> <dim> <index-in> > file.out"<<std::endl;
		std::clog<<"<space>: space, 0 for L2, 1 for InnerProduct"<<std::endl;
		std::clog<<"<dim>: dimensionality of input"<<std::endl;
		std::clog<<"<index-in>: input index"<<std::endl;
        std::clog<<"Note: prints to stdout"<<std::endl;
        return -1;
    }

	std::string indexfilename(argv[3]);
    int space_ID = std::stoi(argv[1]);
	int dim = std::stoi(argv[2]);

	SpaceInterface<float>* space; 
	if (space_ID == 0){
		space = new L2Space(dim);
	} else {
		space = new InnerProductSpace(dim);
	}
    HNSW<float, int> index(space, indexfilename);
	index.dump(std::cout);

    return 0;
}
