/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.BumpableEdge;
import agents.spencerSchumann.Edge;
import agents.spencerSchumann.Tiles;
import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class Scene {
    public ArrayList<Edge> floors = new ArrayList();
    public ArrayList<Edge> walls = new ArrayList();
    public ArrayList<Edge> ceilings = new ArrayList();
    public ArrayList<BumpableEdge> bumpables = new ArrayList();
    public ArrayList<Edge> enemyEmitters = new ArrayList();
    public long constructTime;
    public float originX;
    public float originY;

    public Scene clone() {
        Scene scene = new Scene();
        scene.update(this);
        return scene;
    }

    public void update(Scene scene) {
        this.clearEdges();
        this.add(scene);
        this.originX = scene.originX;
        this.originY = scene.originY;
    }

    public void clearEdges() {
        this.floors.clear();
        this.walls.clear();
        this.ceilings.clear();
        this.bumpables.clear();
        this.enemyEmitters.clear();
    }

    private Scene() {
    }

    public Scene(float f, float f2) {
        this.originX = f;
        this.originY = f2;
    }

    public Scene(MarioForwardModel marioForwardModel, int[][] nArray) {
        long l = System.nanoTime();
        float[] fArray = marioForwardModel.getMarioFloatPos();
        float f = (float)Math.floor(fArray[0] / 16.0f) * 16.0f;
        marioForwardModel.getClass();
        this.originX = f - (float)(16 / 2) * 16.0f;
        float f2 = (float)Math.floor(fArray[1] / 16.0f) * 16.0f;
        marioForwardModel.getClass();
        this.originY = f2 - (float)(16 / 2) * 16.0f;
        boolean[][] blArray = new boolean[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                Scene scene;
                int n = nArray[i][j];
                if (n == 7 || blArray[j][i]) continue;
                if (Tiles.isWall(n)) {
                    scene = new Scene(this.originX, this.originY);
                    scene.expandWall(nArray, blArray, i, j);
                    this.add(scene);
                    continue;
                }
                if (n != 2) continue;
                scene = new Scene(this.originX, this.originY);
                scene.expandLedge(nArray, blArray, i, j);
                this.add(scene);
            }
        }
        this.constructTime = System.nanoTime() - l;
    }

    private void expandWall(int[][] nArray, boolean[][] blArray, int n, int n2) {
        if (blArray[n2][n]) {
            return;
        }
        blArray[n2][n] = true;
        if (n > 0) {
            if (Tiles.isWall(nArray[n - 1][n2])) {
                this.expandWall(nArray, blArray, n - 1, n2);
            } else {
                this.walls.add(new Edge(this.originX + (float)n * 16.0f, this.originY + (float)n2 * 16.0f, this.originX + (float)n * 16.0f, this.originY + (float)(n2 + 1) * 16.0f));
            }
        }
        if (n < nArray.length - 1) {
            if (Tiles.isWall(nArray[n + 1][n2])) {
                this.expandWall(nArray, blArray, n + 1, n2);
            } else {
                this.walls.add(new Edge(this.originX + (float)(n + 1) * 16.0f, this.originY + (float)n2 * 16.0f, this.originX + (float)(n + 1) * 16.0f, this.originY + (float)(n2 + 1) * 16.0f));
            }
        }
        if (n2 > 0) {
            if (Tiles.isWall(nArray[n][n2 - 1])) {
                this.expandWall(nArray, blArray, n, n2 - 1);
            } else {
                this.floors.add(new Edge(this.originX + (float)n * 16.0f, this.originY + (float)n2 * 16.0f, this.originX + (float)(n + 1) * 16.0f, this.originY + (float)n2 * 16.0f));
            }
        }
        if (n2 < nArray[n].length - 1) {
            if (Tiles.isWall(nArray[n][n2 + 1])) {
                this.expandWall(nArray, blArray, n, n2 + 1);
            } else {
                this.ceilings.add(new Edge(this.originX + (float)n * 16.0f, this.originY + (float)(n2 + 1) * 16.0f, this.originX + (float)(n + 1) * 16.0f, this.originY + (float)(n2 + 1) * 16.0f));
            }
        }
        this.coalesce();
    }

    private void expandLedge(int[][] nArray, boolean[][] blArray, int n, int n2) {
        if (blArray[n2][n]) {
            return;
        }
        blArray[n2][n] = true;
        int n3 = n;
        int n4 = n;
        while (n3 > 0 && nArray[n3 - 1][n2] == 2) {
            blArray[n2][--n3] = true;
        }
        while (n4 < nArray.length - 1 && nArray[n4 + 1][n2] == 2) {
            blArray[n2][++n4] = true;
        }
        this.floors.add(new Edge(this.originX + (float)n3 * 16.0f, this.originY + (float)n2 * 16.0f, this.originX + (float)(n4 + 1) * 16.0f, this.originY + (float)n2 * 16.0f));
    }

    private void coalesce() {
        this.coalesce(this.walls);
        this.coalesce(this.ceilings);
        this.coalesce(this.floors);
        this.coalesce(this.enemyEmitters);
    }

    private void coalesce(ArrayList<Edge> arrayList) {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (Edge edge : arrayList) {
                for (Edge edge2 : arrayList) {
                    if (edge == edge2) continue;
                    bl = true;
                    if (edge.x1 == edge2.x1 && edge.y1 == edge2.y1) {
                        throw new RuntimeException("Overlapping edges!");
                    }
                    if (edge.x1 == edge2.x2 && edge.y1 == edge2.y2) {
                        edge.x1 = edge2.x1;
                        edge.y1 = edge2.y1;
                    } else if (edge.x2 == edge2.x1 && edge.y2 == edge2.y1) {
                        edge.x2 = edge2.x2;
                        edge.y2 = edge2.y2;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    arrayList.remove(edge2);
                    break;
                }
                if (!bl) continue;
                continue block0;
            }
        }
    }

    private void add(Scene scene) {
        this.floors.addAll(scene.floors);
        this.walls.addAll(scene.walls);
        this.ceilings.addAll(scene.ceilings);
        this.bumpables.addAll(scene.bumpables);
        this.enemyEmitters.addAll(scene.enemyEmitters);
    }
}

