/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public class EnemyState
extends SpriteState {
    public boolean flyDeath = false;
    public static final float width = 4.0f;

    @Override
    public final float height() {
        return this.type >= 4 && this.type <= 7 ? 24.0f : 12.0f;
    }

    @Override
    public SpriteState clone() {
        EnemyState enemyState = new EnemyState(this.x, this.y, this.type);
        enemyState.xa = this.xa;
        enemyState.ya = this.ya;
        enemyState.facing = this.facing;
        enemyState.deadTime = this.deadTime;
        enemyState.flyDeath = this.flyDeath;
        enemyState.onGround = this.onGround;
        return enemyState;
    }

    public final boolean avoidCliffs() {
        return this.type == 4;
    }

    public final boolean winged() {
        switch (this.type) {
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean spiky() {
        switch (this.type) {
            case 9: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public final boolean noFireballDeath() {
        switch (this.type) {
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    EnemyState(float f, float f2, int n) {
        this.x = f;
        this.y = f2;
        this.type = n;
        this.ya = this.winged() ? 0.6f : 2.0f;
        this.facing = -1;
    }

    @Override
    public boolean move(WorldState worldState) {
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            if (this.flyDeath) {
                this.x += this.xa;
                this.y += this.ya;
                this.ya = (float)((double)this.ya * 0.95);
                this.ya += 1.0f;
            }
            return true;
        }
        float f = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * f;
        if (!this.move(this.xa, 0.0f, worldState)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya, worldState);
        this.ya *= this.winged() ? 0.95f : 0.85f;
        this.xa *= 0.89f;
        if (!this.onGround) {
            this.ya = this.winged() ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged()) {
            this.ya = -10.0f;
        }
        return true;
    }

    @Override
    public void resync(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.xa = f - f3;
        if (this.xa == 0.0f) {
            this.deadTime = 9;
            return;
        }
        this.facing = this.xa < 0.0f ? -1 : 1;
        this.ya = (f2 - f4) * (this.winged() ? 0.95f : 0.85f);
        if (this.xa == 0.0f || this.ya == 0.0f) {
            // empty if block
        }
        if (!this.onGround) {
            this.ya = this.winged() ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged()) {
            this.ya = -10.0f;
        }
    }

    private boolean move(float f, float f2, WorldState worldState) {
        float f3 = this.height();
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f, worldState)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f, worldState)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f, worldState)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f, worldState)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2, f, 0.0f, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + 4.0f, this.y + f2, f, 0.0f, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - 4.0f, this.y + f2 + 1.0f, f, f2, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + 4.0f, this.y + f2 + 1.0f, f, f2, worldState)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - f3, f, f2, worldState)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - 4.0f, this.y + f2 - f3, f, f2, worldState)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + 4.0f, this.y + f2 - f3, f, f2, worldState)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2 - f3, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2 - f3 / 2.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2, f, f2, worldState)) {
                bl = true;
            }
            if (this.avoidCliffs() && this.onGround && !worldState.isBlocking((int)((this.x + f + 4.0f) / 16.0f), (int)(this.y / 16.0f + 1.0f), f, 1.0f)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2 - f3, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2 - f3 / 2.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2, f, f2, worldState)) {
                bl = true;
            }
            if (this.avoidCliffs() && this.onGround && !worldState.isBlocking((int)((this.x + f - 4.0f) / 16.0f), (int)(this.y / 16.0f + 1.0f), f, 1.0f)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (float)((int)((this.x - 4.0f) / 16.0f) * 16) + 4.0f;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (float)((int)((this.x + 4.0f) / 16.0f + 1.0f) * 16) - 4.0f - 1.0f;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (float)((int)((this.y - f3) / 16.0f) * 16) + f3;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4, WorldState worldState) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        return worldState.isBlocking(n, n2, f3, f4);
    }

    @Override
    public SpriteState stomp(WorldState worldState, MarioState marioState) {
        EnemyState enemyState = (EnemyState)this.clone();
        if (enemyState.winged()) {
            --enemyState.type;
            enemyState.ya = 0.0f;
        } else {
            enemyState.deadTime = 10;
            if (this.type == 4 || this.type == 6) {
                worldState.addShell(this.x, this.y);
            }
        }
        return enemyState;
    }

    @Override
    public WorldState collideCheck(WorldState worldState, MarioState marioState) {
        if (this.deadTime != 0) {
            return worldState;
        }
        float f = marioState.x - this.x;
        float f2 = marioState.y - this.y;
        float f3 = this.height();
        if (f > -12.0f && f < 12.0f && f2 > -f3 && f2 < marioState.height()) {
            if (!(this.spiky() || !(marioState.ya > 0.0f) || !(f2 <= 0.0f) || marioState.onGround && marioState.wasOnGround)) {
                worldState = worldState.stomp(this, marioState);
            } else {
                marioState.getHurt();
            }
        }
        return worldState;
    }
}

