/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public final class BulletBillState
extends SpriteState {
    public static final float width = 4.0f;

    @Override
    public final float height() {
        return 12.0f;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    @Override
    public SpriteState clone() {
        BulletBillState bulletBillState = new BulletBillState(this.x, this.y, this.facing);
        bulletBillState.xa = this.xa;
        bulletBillState.ya = this.ya;
        bulletBillState.facing = this.facing;
        bulletBillState.deadTime = this.deadTime;
        return bulletBillState;
    }

    BulletBillState(float f, float f2, int n) {
        this.x = f;
        this.y = f2;
        this.type = 8;
        this.facing = n;
        this.xa = 4 * this.facing;
    }

    BulletBillState(float f, float f2, MarioState marioState) {
        this.x = f;
        this.y = f2;
        this.type = 8;
        this.facing = f < marioState.x ? 1 : -1;
        this.xa = 4 * this.facing;
    }

    @Override
    public boolean move(WorldState worldState) {
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            this.x += this.xa;
            this.y += this.ya;
            this.ya = (float)((double)this.ya * 0.95);
            this.ya += 1.0f;
            return true;
        }
        float f = 4.0f;
        this.xa = (float)this.facing * f;
        this.x += this.xa;
        return true;
    }

    @Override
    public SpriteState stomp(WorldState worldState, MarioState marioState) {
        BulletBillState bulletBillState = (BulletBillState)this.clone();
        bulletBillState.xa = 0.0f;
        bulletBillState.ya = 1.0f;
        bulletBillState.deadTime = 100;
        return bulletBillState;
    }

    @Override
    public WorldState collideCheck(WorldState worldState, MarioState marioState) {
        if (this.deadTime != 0) {
            return worldState;
        }
        float f = marioState.x - this.x;
        float f2 = marioState.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > -this.height() && f2 < marioState.height()) {
            if (marioState.ya > 0.0f && f2 <= 0.0f && (!marioState.onGround || !marioState.wasOnGround)) {
                worldState = worldState.stomp(this, marioState);
            } else {
                marioState.getHurt();
            }
        }
        return worldState;
    }
}

