#!/bin/bash

EXPT="wod-medium"  # DON'T CHANGE THIS EVEN IF EVALING ON OTHER MINIHACK ENVS
N="range(3)"
TAG="NeurIPS"

# WoD
ENVS="MiniHack-WoD-Medium-v0,MiniHack-Wod-Hard-v0"
ACTION_SPACE="combatpickup"
TIME="1000"
MSGWEIGHT="50.0"

# River
# ENVS="MiniHack-River-v0"
# ACTION_SPACE="combatpickup"
# TIME="500"
# MSGWEIGHT="50.0"

# Quest
# ENVS="MiniHack-Quest-Easy-v0,MiniHack-Quest-Medium-v0"
# ACTION_SPACE="quest"
# TIME="500"
# MSGWEIGHT="30.0"

# MULTIROOM
# ENVS="MiniHack-MultiRoom-N2-Extreme-v0,MiniHack-MultiRoom-N4-Extreme-v0"
# ACTION_SPACE="default"
# TIME="1600"
# MSGWEIGHT="50.0"

# NovelD
python -m minihack.agent.polybeast.polyhydra -m +experiment=$EXPT group="$TAG-\${env}-\${model}" model=noveld n="$N" env=$ENVS filter_messages=none action_space=$ACTION_SPACE int.intrinsic_weight=0.1

# L-NovelD
python -m minihack.agent.polybeast.polyhydra -m +experiment=$EXPT group="$TAG-\${msg.onehot}onehot-\${env}-\${model}-msg-\${int.separate_message_weight}-\${int.separate_message_state_counter}-\${int.separate_message_novelty_learning_rate}lr" model=noveld n="$N" env=$ENVS int.separate_message_novelty=true int.separate_message_weight="$MSGWEIGHT" filter_messages=none int.intrinsic_weight=0.05 action_space=$ACTION_SPACE msg.onehot=false

# Ablation: onehot
python -m minihack.agent.polybeast.polyhydra -m +experiment=$EXPT group="$TAG-\${msg.onehot}onehot-\${env}-\${model}-msg-\${int.separate_message_weight}-\${int.separate_message_state_counter}-\${int.separate_message_novelty_learning_rate}lr" model=noveld n="$N" env=$ENVS int.separate_message_novelty=true int.separate_message_weight="$MSGWEIGHT" filter_messages=none int.intrinsic_weight=0.05 action_space=$ACTION_SPACE msg.onehot=true &

# Ablation: combined
python -m minihack.agent.polybeast.polyhydra -m +experiment=$EXPT group="$TAG-\${env}-\${model}-combined" model=noveld n="$N" env=$ENVS filter_messages=none action_space=$ACTION_SPACE int.intrinsic_weight=0.05 int.input=crop_msg

# Ablation: message only
python -m minihack.agent.polybeast.polyhydra -m +experiment=$EXPT group="$TAG-\${msg.onehot}onehot-\${env}-\${model}-msg-\${int.separate_message_weight}-\${int.separate_message_state_counter}-\${int.separate_message_novelty_learning_rate}lr-MSGONLY" model=noveld n="$N" env=$ENVS int.separate_message_novelty=true int.separate_message_weight="$MSGWEIGHT" filter_messages=none int.intrinsic_weight=0.05 action_space=$ACTION_SPACE msg.onehot=false noveld.weight=0.0
