import pickle
import json

from matplotlib import lines

def dump_to_bin(obj, fname):
    with open(fname, 'wb') as f:
        pickle.dump(obj, f)

def load_bin(fname):
    with open(fname, 'rb') as f:
        return pickle.load(f)

def read_json(fname):
    with open(fname, encoding='utf-8') as f:
        return json.load(f)

def dump_json(obj, fname, indent=None):
    with open(fname, 'w', encoding='utf-8') as f:
        return json.dump(obj, f, indent=indent)

def read_jsonlines(fname):
    with open(fname) as f:
        lines = f.readlines()
    return [json.loads(x) for x in lines]

def add_engine_argumenet(parser):
    parser.add_argument('--do_base', dest='do_instruct', default=True, action='store_false')
    parser.add_argument('--engine', default='davinci', choices=['davinci', 'curie', 'babbage', 'ada'])

_INSTRUCT_ENGINE_MAPPING = {
    'davinci': 'davinci-instruct-beta-v3',
    'curie': 'curie-instruct-beta-v2',
    'babbage': 'babbage-instruct-beta',
    'ada': 'ada-instruct-beta',
}

def specify_engine(args):
    if not args.do_instruct:
        args.engine_name = args.engine
        return
    args.engine_name = args.engine + '-inst'
    args.engine = _INSTRUCT_ENGINE_MAPPING[args.engine]

