# -*- coding: utf-8 -*-
"""
Spyder Editor

This is a temporary script file.
"""

import numpy as np
import pandas as pd

import argparse as args

def filterFullMethods(methods) :
	
	methods.sort()
	fmethods = []
	
	for m in methods :
		
		ok = True
		for fm in fmethods :
			if m.find(fm) == 0:
				ok = False
				break
		
		if ok :
			fmethods.append(m)
	
	return fmethods

if __name__ == "__main__" :
	
	parser = args.ArgumentParser(description='Estimate the uncertainty associated with our test set size by using monte carlo simulation.')
	parser.add_argument("--inputfile", '-i', default="../detailled_results.xlsx", help="The xlsx file with the data")
	parser.add_argument("--number", "-n", type=int, default=50, help="Number of random permutations to perform")
	parser.add_argument("--metrics", "-m", default="MAE,BAD2", help="metrics to output")
	parser.add_argument("--latex", action='store_true', help="Print the output as a latex table")
	
	args = parser.parse_args()
	
	data = pd.read_excel(args.inputfile, sheet_name = 'Performance Per Images', header = 0, skiprows = 1).dropna()
	
	methods = data['Method'].unique()
	images = data['Image'].unique()
	metrics = list(data)[2:]
	
	aggregated_per_method = data.groupby(['Method']).mean()
	
	filtered_methods = filterFullMethods(methods) #full methods without the ablated ones
	
	def bootstrapRelChange(seq, prop = 0.5, subfunc = 'mean', nExp = args.number) :
		
		n = int(np.round(prop*len(seq)))
		
		total = seq.apply(subfunc)
		rel = 0
		
		for it in np.arange(nExp) :
			rel += (total - seq.sample(n).apply(subfunc)).abs() / total.abs()
		
		return rel / nExp
	
	bootstrapped = data.groupby(['Method']).aggregate(bootstrapRelChange, subfunc = 'mean')
			
	
	selected_metrics = args.metrics.split(',')
	
	allMetricInfos = None
	
	for metric in selected_metrics :
		metric_active = metric + "-active"
		metric_passive = metric + "-passive"
		metric_relchange = metric + "-rel-change"
		metric_active_ev50 = metric_active + "-expectedvariation50"
		metric_passive_ev50 = metric_passive + "-expectedvariation50"
		
		aggregated = aggregated_per_method[[metric_passive, metric_active]].copy()
		aggregated[metric_relchange] = (aggregated[metric_passive] - aggregated[metric_active]).abs() / (aggregated[metric_passive]).abs()
		
		bootstrapped_m = bootstrapped[[metric_passive, metric_active]].copy()
		bootstrapped_m.rename(columns = {metric_passive: metric_passive_ev50, metric_active: metric_active_ev50}, inplace = True)
		
		metric_infos = pd.concat([aggregated, bootstrapped_m], axis=1)
		
		minfos = metric_infos[[metric_relchange, metric_passive_ev50, metric_active_ev50]]
		
		if allMetricInfos is None :
			allMetricInfos = minfos.copy()
		else :
			allMetricInfos = pd.concat([allMetricInfos, minfos], axis=1)
			
			
	if args.latex :
		format_px = lambda x : "{:0.2f}px".format(x)
		format_prct = lambda x : "{:0.0f}%".format(100*x)
		
		print(allMetricInfos.to_latex(float_format = format_prct))
	else :
		print(allMetricInfos)
		
	
	print("")
	
	filteredData = data[data['Method'].isin(filtered_methods)].copy()
	
	for metric in selected_metrics :
		metric_active = metric + "-active"
		metric_passive = metric + "-passive"
		metric_diff = metric + "-diff-passive-active"
	
		filteredData[metric_diff] = filteredData[metric_passive] - filteredData[metric_active]
		
		pv = filteredData.pivot(index='Image', columns='Method', values=metric_diff)
		
		if args.latex :
			format_prct = lambda x : "{:0.0f}%".format(100*x)
			
			print(f"\\caption{{Pearson correlation coefficient of the different between passive and active scores for metric {metric}}}")
			print(pv.corr().to_latex(float_format = format_prct))
			print("")
		else :
			print(f"Pearson correlation coefficient of the different between passive and active scores for metric {metric}:")
			print(pv.corr())
			print("")
