# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Element-wise Soft Thresholding Function for Matrix
#' @description Soft thresholding function for Matrix
#'
#' @param A Matrix
#' @param a scalar
#' @param diag  Should diagonal elements of the Matrix be thresholding? Default is FALSE.
#' @return Matrix after threholding
#' 
#' @export
#'
soft <- function(A, a, diag = 0L) {
    .Call(`_EQUAL_soft`, A, a, diag)
}

#' @title Non-symmetric version of EQUAL
#' @description ADMM algorithm for high precision matrix estimation using asymmetic loss
#' @param X data matrix of dimension n*p.
#' @param lambda user supplied tuning parameter; 
#' @param err the precision used to stop the convergence. Default is 1e-5. 
#' Iterations stop when average absolute parameter change is less than \code{err}.
#' @param maxIter Maximum number of iterations. Default is 1000.
#' @param rho step parameter for the ADMM. Default is 1.
#' @param diag  Should diagonal elements of the Matrix be thresholding? Default is FALSE.
#' @return A list with components
#' \item{Omega}{a list of sparse p*p matrices corresponding to lambda.}
#' \item{lambda}{the used lambda for the solution path.}
#' \item{niter}{the number of iterations for each element of lambda.}
#' 
#' @export
#' 
equal1 <- function(X, lambda, err = 10^(-5), maxIter = 10^3L, rho = 1, diag = 0L) {
    .Call(`_EQUAL_equal1`, X, lambda, err, maxIter, rho, diag)
}

#' @title Symmetric version of EQUAL
#' @description ADMM algorithm for high precision matrix estimation using symmetic loss
#' @param X data matrix of dimension n*p.
#' @param lambda user supplied tuning parameter; 
#' @param err the precision used to stop the convergence. Default is 1e-5. 
#' Iterations stop when average absolute parameter change is less than \code{err}.
#' @param maxIter Maximum number of iterations. Default is 1000.
#' @param rho step parameter for the ADMM. Default is 1.
#' @param diag  Should diagonal elements of the Matrix be thresholding? Default is FALSE.
#' @return A list with components
#' \item{Omega}{a list of sparse p*p matrices corresponding to lambda.}
#' \item{lambda}{the used lambda for the solution path.}
#' \item{niter}{the number of iterations for each element of lambda.}
#' 
#' @export
#' 
equal2 <- function(X, lambda, err = 10^(-5), maxIter = 10^3L, rho = 1, diag = 0L) {
    .Call(`_EQUAL_equal2`, X, lambda, err, maxIter, rho, diag)
}

