﻿>📋  A README.md for code
# Estimating graphical models for count data with applications to single-cell gene network

This paper proposes a new method PLNet of network inference for count data. PLNet is a R package for calculating the precision matrix of Poisson log-normal model using the maximum marginal log-likelihood estimator (MMLE) and the D-trace loss. We first estimate the covariance matrix by MMLE and then infer the precision matrix by D-trace loss using the modified function from R package EQUAL.

## Requirements

To know requirements for our R package PLNet, simulation and real data analysis, see requirements.txt. 

To install these packages, see package_install.R in the folder "dependencies".

## Training

In the folder "training", we show the code for simulation in PLNet_simulation.R, the code for real data "ifnb" network estimation in PLNet_realdata.R, and the code for benchmark analysis in Benchmark_realdata.R. PLNet_simulation.R outputs criterions including AUC, AUPR and time cost. PLNet_realdata.R outputs the networks estimated by PLNet and VPLN, see detials in the R code files. Benchmark_realdata.R outputs the networks estimated by PLNet and VPLN related to benchmark analysis, see detials in the R code files. 

## Evaluation
This folder "evaluation" provides the code for the evaluation of the real data network estimated by PLNet and VPLN in Realdata_evaluation and the code for benchmark analysis of PLNet and VPLN. The output gives all the figures and tables shown in our paper and Supplementary Material. Additionally, the sub folder "htftarget" contains the gene regulatory relationship related to our analysis from hTFtarget database, and the Rdata "TF_list_all" is a list including the known TFs.



## Results

Our model achieves the following performance on :

### Simulation for n=2000, p=100, Dropout = 0.6.

| Model name         | AUC      | AUPR        | Time cost (minute)  |
| ------------------ |--------- | ----------- |---------------------|
| PLNet              |         1|      0.96   |     0.66            |
| VPLN               |      0.99|      0.89   |     6.26            |
| glasso             |      0.53|      0.04   |     0.08            |







