## Dependencies
* Python 3.7
* PyTorch 1.7
* CUDA 11.1

## Installation
```
ROOT=/path/to/object_pose
cd $ROOT/lib/nn_distance
python setup.py install --user
```

## Datasets
Download [camera_train](http://download.cs.stanford.edu/orion/nocs/camera_train.zip), [camera_val](http://download.cs.stanford.edu/orion/nocs/camera_val25K.zip),
[real_train](http://download.cs.stanford.edu/orion/nocs/real_train.zip), [real_test](http://download.cs.stanford.edu/orion/nocs/real_test.zip),
[ground-truth annotations](http://download.cs.stanford.edu/orion/nocs/gts.zip),
and [mesh models](http://download.cs.stanford.edu/orion/nocs/obj_models.zip)
provided by [NOCS](https://github.com/hughw19/NOCS_CVPR2019).

Unzip and organize these files in $ROOT/data and follow the steps in [object-deform](https://github.com/mentian/object-deformnet) to process the data. And the structure of data after pre-processing should be like as follows:
```
data
├── CAMERA
│   ├── train
│   └── val
├── Real
│   ├── train
│   └── test
├── gts
│   ├── val
│   └── real_test
└── obj_models
    ├── train
    ├── val
    ├── real_train
    └── real_test

```
## Training
```
CUDA_VISIBLE_DEVICES=0 python train_pose.py --version v4 --result_dir $work_dir --n_cat 1 --select_class $class_name --imp --use_nocs_map
```
Some optional commands (w/ default value in square bracket):
- training data ``--dataset [CAMERA+REAL]``
- batch size ``--batch_size [32] ``
- number of epochs ``--max_epoch [50]``
More options please refer the ``train_pose.py``

## Evaluation
```
python evaluate_pose.py --use_nocs_map --version v4 --imp --model $work_dir --select_class $class_name --n_cat 1 --data real_test
```