using JLD2, Plots

include("Muscada.jl")
include("Hedge.jl")
include("bimat.jl")



# standard worst-case online learning bound on regret per round
# NB: this is with knowledge of T up front
wcbd(σ, K, T) = σ*sqrt(2*log(K)/T)

# worst-case gap bound from row and column worst-case regret bounds
wcbd(T) = wcbd(maximum(σrow), log(length(σrow)), T) + wcbd(maximum(σcol), length(σcol), T)

# gap bound in the pretty-happy-case that the effective range is smaller
happy(T) = wcbd(maximum(σrow[pstar .> 1e-5]), log(length(σrow)), T) + wcbd(maximum(σcol[qstar .> 1e-5]), length(σcol), T)

#Owcbd(σ, K, T) = σ*log(K)/T; # TODO: triple double check this
# worst-case gap bound from row and column worst-case regret bounds
Owcbd(T) =  4*max(maximum(σrow), maximum(σcol))*(log(length(σrow))+log(length(σcol)))/T

Ohappy(T) = 4*max(maximum(σrow[pstar .> 1e-5]), maximum(σcol[qstar .> 1e-5]))*(log(length(σrow))+log(length(σcol)))/T




@load "games.jld2"

# make the plot

# title="Saddle Point Gap",
plot(xlabel="Rounds(t)", ylabel="Saddle Point Gap", scale=:log10, legend=:bottomleft)

order = [3,1,2]

for (colid, (P, Q, pbar, qbar, itgap, avgap, tune1, optimistic, rangeadaptive, regh)) in enumerate(res[order])

    lbl = if regh
        "Hedge’(1/√t)"
    else
        #namea = if optimistic "O" else "P" end
        nameb = if tune1 "H₁" else "H₂" end
        namec = if rangeadaptive "A" else "N" end
        namec = if rangeadaptive "(σ)" else "(σₘₐₓ)" end
        "Tuning₃’$namec"
    end

    if colid == 1
        plot!(Tstep, wcbd, label="σₘₐₓ/√t bound", style=:dash, lc=3)
    elseif colid == 2
        plot!(Tstep, Owcbd, label="σₘₐₓ/t bound", style=:dash, lc=1)
    else
        plot!(Tstep, Ohappy, label="σᵣₑₐₗ/t bound", style=:dash, lc=2)
    end

    plot!(Tstep, avgap[Tstep], label="$lbl avg", lc=order[colid])
    plot!(Tstep, itgap[Tstep], label="$lbl last", linestyle=:dot, lc=order[colid])
end


#plot!(Tstep, happy, label="σₘₐₓ(support) bound", style=:dash)




plot!(ylim=(1e-6, 1e3), xticks=[1, 10^1, 10^3, 10^5, 10^7], xrange=(1,T))

#plot!(size=div.((600,400).*3,5))

plot!(guidefontsize=8)
plot!(legendfontsize=7)

# export
savefig("graph_games2.pdf")

# and reshow
gui()
