folder = 'data/exp2-full/';
fin = [folder,'in_i%d_j%d.mat'];
fout = [folder,'out.txt'];
J = 100; %number of repetitions
[Gap,ErrX] = read_iters(fin,fout,2,J);

hf = figure(3);
clf
T = 12;
col = {[0,.7,0],[.7,0,0]};
mytitle = {'Original SDP (\sigma=0)','Perturbed SDP (\sigma=0.2)'};

ha = tight_subplot(1,2,.0,[.14,.09],[.112,.015]);

for i = 1:2
ax = ha(i);
axes(ax);

% computations
Gap1 = merge_cols(Gap(i,:));
Gap1 = Gap1(1:T+1,:);
t = (0:T)';
Y = log10(Gap1);
y = mean(Y,2);
y = movmean(y,2);
e = std(Y,0,2);
e = movmean(e,2);

% draw plots
hold on
hPlot = plot(t,y);
tt = linspace(0,T,50)';
e1 = pchip(t,y-e,tt);
e2 = pchip(t,y+e,tt);
hFill = fill([tt+.1;flipud(tt)],[e1;flipud(e2)],[i/2 1.5-i/2 .7]);
hold off

% plot properties
set(hPlot,...
    'LineStyle','-',...
    'Color',.5*col{i},...
    'Marker', 'o',...
    'MarkerSize',7,...
    'LineWidth',2.8,...
    'MarkerFaceColor',col{i},...
    'MarkerEdgeColor',.5*col{i})
set(hFill,...
    'Linestyle','none',...
    'facealpha',.3);

% scale
set(ax,...
    'XLim',[0-.1,T+.1],...
    'XTickLabel',{'','2','4','6','8','10','12'},...
    'YLim',[-9.5,1.5],...
    'YTickLabel',{' 10^{-8}',' 10^{-6}',' 10^{-4}',' 10^{-2}',' 10^0'})

% axes labels
hTitle = title(mytitle{i});
hXLabel = xlabel('Iteration');
if i==1
    hYLabel = ylabel('Criticality residual'); 
else
    yticklabels([])
end

% legend
hLegend = legend('mean','std');
set(hLegend,...
    'Position',[0.15+.435*(i-1) 0.19 0.1 0.08],...
    'LineWidth',2.0);

% fonts
set(ax,'FontName', 'Helvetica', 'FontSize', 22);
set(hLegend, 'FontSize', 22);
set([hXLabel, hYLabel], 'FontName', 'AvantGarde', 'FontSize', 24);
set( hTitle, ...
    'FontName', 'AvantGarde',...
    'FontSize', 24, ...
    'FontWeight' , 'normal');

% axis properties
set(ax, ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'XTick'       , 0:2:12,...
  'YTick'       , (-8:2:0), ...
  'Layer'       ,'top', ....
  'LineWidth'   , 2.5         );

end
set(ax,'YAxisLocation','right')

% figure properties
pause(.1)
set(hf,...,
    'Color', [1,1,1],...
    'Renderer', 'painters',...
    'Units', 'inches',...
    'PaperPositionMode', 'auto')
set(hf,'WindowStyle','normal','InnerPosition', [10 4 11 7]);

% print('exp2.png','-dpng','-r300')