function [w,C,D] = w_fun(M,N,q,d,B)

%% decoding weights

Ni=round(N/q);                            % ratio E to I neurons is q to 1
N_all=[N,Ni];
w=cell(2,1);

for ii=1:2
    
    w_ran=randn(M,N_all(ii));   % standard normal    
    w{ii}=w_ran./M;             % divide with the number of features
    
end

w{2}=w{2}.*d;                       % sets STD of decoding weights of I neurons to d*sigma_w^E (sigma_w^E=1)

%% fast connectivity matrices

C=cell(4,1);

weights1={[],w{2},w{2},w{1}};
weights2={[],w{2},w{1},w{2}};

for ii=2:4
    
    w1=weights1{ii};
    w2=weights2{ii};
    
    proj=w1'*w2;                                            % projection of weights + white noise
                                              
    C{ii}=(proj.*(sign(proj)==1));                          % keep only positive sign
    
end

%% slower connectivity matrices

D=cell(2,1);
D_ee=w{1}'*B*w{1};
D_ie=w{2}'*B*w{1};

signee=(sign(D_ee)==1);
signie=(sign(D_ie)==1);

D{1}=D_ee.*signee;  % removes connections between neurons with different selectivity
D{2}=D_ie.*signie;


end


