
import numpy as np
import matplotlib.pyplot as plt
import random
import numpy.linalg as la
import math
import random
from math import pi


def fig(molecure, ground_energy, n_qubits, n_params, iteration, time, optimizer, noise_con, noise_rate):

    line = 1.5
    if(noise_con==0):
        folder = "./"+molecure+"/"+str(n_qubits)+"_"+str(n_params)+"_"+optimizer
        folder_gaussian = folder+"_gaussian_"+str(noise_rate)+"/"
        folder_zero = folder+"_zero_"+str(noise_rate)+"/"
        folder_uniform = folder+"_uniform_"+str(noise_rate)+"/"
    else: 
        folder = "./"+molecure+"/"+str(n_qubits)+"_"+str(n_params)+"_s"+optimizer
        folder_gaussian = folder+"_gaussian/"
        folder_zero = folder+"_zero/"
        folder_uniform = folder+"_uniform/"

    figure_iteration_x = np.zeros(iteration)
    for i in range(iteration):
        figure_iteration_x[i] = i+1

    loss = np.zeros((time,iteration))
    for i in range(time):
        loss[i] = np.load(folder_gaussian+"loss_"+str(i)+".npy")[:iteration]
    loss_mean = np.mean(loss, axis = 0)
    loss_min = np.min(loss, axis = 0)
    loss_max = np.max(loss, axis = 0)
    plt.plot(figure_iteration_x, loss_mean - ground_energy, linestyle='-', label = "gaussian", color = 'red', lw = line)
    plt.fill_between(figure_iteration_x, loss_min - ground_energy, loss_max - ground_energy, color='red', alpha=0.3)

    loss = np.zeros((time,iteration))
    for i in range(time):
        loss[i] = np.load(folder_uniform+"loss_"+str(i)+".npy")[:iteration]
    loss_mean = np.mean(loss, axis = 0)
    loss_min = np.min(loss, axis = 0)
    loss_max = np.max(loss, axis = 0)
    plt.plot(figure_iteration_x, loss_mean - ground_energy, linestyle=':', label = "uniform", color = 'blue', lw = line)
    plt.fill_between(figure_iteration_x, loss_min - ground_energy, loss_max - ground_energy, color = 'blue', alpha=0.3)

    loss = np.zeros((time,iteration))
    for i in range(time):
        loss[i] = np.load(folder_zero+"loss_"+str(i)+".npy")[:iteration]
    loss_mean = np.mean(loss, axis = 0)
    loss_min = np.min(loss, axis = 0)
    loss_max = np.max(loss, axis = 0)
    #print(loss_mean)
    plt.plot(figure_iteration_x, loss_mean - ground_energy, linestyle='--', label = "zero", color = 'black', lw = line)
    plt.fill_between(figure_iteration_x, loss_min - ground_energy, loss_max - ground_energy, color = 'black', alpha=0.3)

    plt.yscale('log')

    if(optimizer == 'gd'):
        plt.xlabel('training iteration with GD', fontsize = 17)
    if(optimizer == 'adam'):
        plt.xlabel('training iteration with Adam', fontsize = 17)

    plt.ylabel(r"$f-f_*$", fontsize = 17)
    plt.xticks(fontsize = 12)
    plt.yticks(fontsize = 12)

    plt.grid(visible=True, axis = 'y', which='major', color='#666666', linestyle='--')
    # plt.minorticks_on()
    # plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend(prop = {'size': 18})
    plt.savefig("chem_energy"+"_"+optimizer+"_"+str(n_qubits)+"_"+str(n_params)+"_"+str(noise_con)+"_"+str(noise_rate)+".pdf")
    plt.close()

    line = 1.5
    figure_iteration_x = np.zeros(iteration)
    for i in range(iteration):
        figure_iteration_x[i] = i+1


    gradnorm = np.zeros((time,iteration))
    for i in range(time):
        gradnorm[i] = np.load(folder_gaussian+"gradnorm_"+str(i)+".npy")[:iteration]
    gradnorm_mean = np.mean(gradnorm, axis = 0)
    gradnorm_min = np.min(gradnorm, axis = 0)
    gradnorm_max = np.max(gradnorm, axis = 0)
    plt.plot(figure_iteration_x, gradnorm_mean, linestyle='-', label = "gaussian", color = 'crimson', lw = line)
    plt.fill_between(figure_iteration_x, gradnorm_min, gradnorm_max, color='crimson', alpha=0.3)

    gradnorm = np.zeros((time,iteration))
    for i in range(time):
         gradnorm[i] = np.load(folder_uniform+"gradnorm_"+str(i)+".npy")[:iteration]
    gradnorm_mean = np.mean(gradnorm, axis = 0)
    gradnorm_min = np.min(gradnorm, axis = 0)
    gradnorm_max = np.max(gradnorm, axis = 0)
    plt.plot(figure_iteration_x, gradnorm_mean, linestyle=':', label = "uniform", color = 'blue', lw = line)
    plt.fill_between(figure_iteration_x, gradnorm_min, gradnorm_max, color='blue', alpha=0.3)

    gradnorm = np.zeros((time,iteration))
    for i in range(time):
        gradnorm[i] = np.load(folder_zero+"gradnorm_"+str(i)+".npy")[:iteration]
    gradnorm_mean = np.mean(gradnorm, axis = 0)
    gradnorm_min = np.min(gradnorm, axis = 0)
    gradnorm_max = np.max(gradnorm, axis = 0)
    if(gradnorm_mean[1]>1/np.power(10,6)):
        plt.plot(figure_iteration_x, gradnorm_mean, linestyle='--', label = "zero", color = 'black', lw = line)
        plt.fill_between(figure_iteration_x, gradnorm_min, gradnorm_max, color='black', alpha=0.3)

    plt.yscale('log')
    if(optimizer == 'gd'):
        plt.xlabel('training iteration with GD', fontsize = 17)
    if(optimizer == 'adam'):
        plt.xlabel('training iteration with Adam', fontsize = 17)


    plt.ylabel('gradient norm', fontsize = 17)

    plt.xticks(fontsize = 12)
    plt.yticks(fontsize = 12)

    plt.grid(visible=True, axis = 'y', which='major', color='#666666', linestyle='--')
    # plt.minorticks_on()
    # plt.grid(b=True, which='minor', color='#999999', linestyle=':', alpha=0.2)
    plt.legend(prop = {'size': 18})


    plt.savefig("chem_gradnorm"+"_"+optimizer+"_"+str(n_qubits)+"_"+str(n_params)+"_"+str(noise_con)+"_"+str(noise_rate)+".pdf")
    plt.close()




iteration = 100
time = 5


molecure, ground_energy, n_qubits, n_params = "LiH", -7.8825378193, 10, 24

fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "adam", 0, 0)
fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "adam", 0, 1)
fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "adam", 1, 0)
fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "gd", 0, 0)
fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "gd", 0, 1)
fig(molecure, ground_energy, n_qubits, n_params, iteration, time, "gd", 1, 0)
