from timeit import default_timer as timer


class TimeStatistics:
    def __init__(self):
        self.start_time = timer()
        self.io_duration = 0.0
        self.train_duration = 0.0
        self.eval_duration = 0.0
        self.forward_duration = 0.0
        self.loss_eval_duration = 0.0
        self.backward_duration = 0.0
    
class AverageMeter(object):
    """Computes and stores the average and current value"""
    def __init__(self, name, fmt=':f'):
        self.name = name
        self.fmt = fmt
        self.reset()

    def reset(self):
        self.val = 0
        self.avg = 0
        self.sum = 0
        self.count = 0

    def update(self, val, n=1):
        self.val = val
        self.sum += val * n
        self.count += n
        self.avg = self.sum / self.count

    def __str__(self):
        fmtstr = '{name} {val' + self.fmt + '} ({avg' + self.fmt + '})'
        return fmtstr.format(**self.__dict__)


if __name__ == "__main__":
    pass