import os
import glob
import scipy
import random
import numpy as np
from PIL import Image
from matplotlib import pyplot as plt
from skimage.io import imread, imsave
import cv2

import argparse

parser = argparse.ArgumentParser(description='PyTorch')
parser.add_argument('--level', default='H', type=str)
parser.add_argument('--percents', default=1, type=int)

args = parser.parse_args()


root_dir_GT = '/public/data1/users/zhaiwei16/VOC/FGDataset' + args.level + '/TrainDataset' + str(args.percents) + '/GT/'
root_dir_Imgs = '/public/data1/users/zhaiwei16/VOC/FGDataset' + args.level + '/TrainDataset' + str(args.percents) + '/Imgs/'
label_ext = '.png'
image_ext = '.jpg'

dir_GT = os.listdir(root_dir_GT)
random.shuffle(dir_GT)
dir_GT = dir_GT[:(3500-35*args.percents)]
print(len(dir_GT))

for line in dir_GT:
    name = line.split('.')[0]
    gt_name = root_dir_GT + line
    img_name = root_dir_Imgs + name + image_ext
    #print(gt_name)
    os.remove(gt_name)
    os.remove(img_name)

count = os.listdir(root_dir_GT)
print(len(count))