import psutil
import time
import os
from subprocess import Popen
from datetime import datetime


# Control variables
infile = 'd_reg_exp.py'
outfile = 'd_reg_exp_temp'
changes = dict()
clusters = [2, 4, 5, 8]
nodes = [400, 800, 1200, 1600, 2000]
degree = [40, 80, 120]
groups = [0.1, 0.3, 0.5, 0.7, 0.9]
ranks = groups + [None]
curr_idx = 0
for num_nodes in nodes:
    for deg in degree:
        for num_clusters in clusters:
            changes[curr_idx] = [('use_config = 0', 'use_config = 0'),
                                 ('\'num_nodes\': 1000', '\'num_nodes\': ' + str(num_nodes)),
                                 ('\'degree\': 100', '\'degree\': ' + str(deg)),
                                 ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_clusters))]
            curr_idx += 1

            for val in groups:
                num_groups = int(val * num_nodes)
                changes[curr_idx] = [('use_config = 0', 'use_config = 2'),
                                     ('\'num_nodes\': 1000', '\'num_nodes\': ' + str(num_nodes)),
                                     ('\'degree\': 100', '\'degree\': ' + str(deg)),
                                     ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_clusters)),
                                     ('\'num_groups\': 5', '\'num_groups\': ' + str(num_groups))]
                curr_idx += 1

            for val in ranks:
                if val is None:
                    changes[curr_idx] = [('use_config = 0', 'use_config = 1'),
                                         ('\'num_nodes\': 1000', '\'num_nodes\': ' + str(num_nodes)),
                                         ('\'degree\': 100', '\'degree\': ' + str(deg)),
                                         ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_clusters))]
                    curr_idx += 1
                    continue

                rank = int(val * num_nodes)
                changes[curr_idx] = [('use_config = 0', 'use_config = 3'),
                                     ('\'num_nodes\': 1000', '\'num_nodes\': ' + str(num_nodes)),
                                     ('\'degree\': 100', '\'degree\': ' + str(deg)),
                                     ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_clusters)),
                                     ('\'rank\': 5', '\'rank\': ' + str(rank))]
                curr_idx += 1


with open(infile) as f:
    content = f.read()

idx = 0
for key in changes:

    count = 0
    while count < 5:
        count = count + 1 if (psutil.cpu_percent(0.1) < 75 and psutil.virtual_memory().percent < 80) else 0
        time.sleep(0.2)

    new_content = content[:]
    for old, new in changes[key]:
        new_content = new_content.replace(old, new)

    curr_time = datetime.now()
    exp_name = 'DReg-' + str(curr_time.month) + '-' + str(curr_time.day) + '-' + str(curr_time.hour) + '-' + \
               str(curr_time.minute) + '-' + str(curr_time.second)
    new_content = new_content.replace('name = \'default\'', 'name = \'' + exp_name + '\'')

    curr_file = outfile + '_' + str(key) + '.py'
    with open(curr_file, 'w') as f:
        f.write(new_content)

    process = Popen(['python', curr_file])
    idx += 1
    print('Started:', idx, 'of', len(changes))

    time.sleep(1)
    os.remove(curr_file)


time.sleep(60)
