from typing import Sequence, Callable

import wandb
from wandb.apis.public import Runs, Run


def get_runs_in_project(entity: str, project_name: str):
    """Return the runs in a project."""
    api = wandb.Api()

    return api.runs(entity + "/" + project_name)


def filter_runs_by_conditions(runs: Runs, condition_lambdas: Sequence[Callable[[Runs], bool]]):
    """Return a list of runs that satisfy all the requested conditions."""
    # Iterate over each run, and only accept the ones that satisfy all the conditions.
    satisfying_runs = list()
    for run in runs:
        are_each_condition_satisfied = list()
        for cond in condition_lambdas:
            try:
                satisfies_current_condition = cond(run)
                if satisfies_current_condition:
                    are_each_condition_satisfied.append(True)
                else:
                    are_each_condition_satisfied.append(False)
            except:
                # Exception happens when the queried property doesn't exist in the run. Reject in this case.
                are_each_condition_satisfied.append(False)

        are_all_conditions_satisfied = all(are_each_condition_satisfied)
        if are_all_conditions_satisfied:
            satisfying_runs.append(run)
    return satisfying_runs
