from spaghettini import quick_register

from src.mains.task_getters import get_system_and_trainer
from src.utils.misc import stdlog


@quick_register
def test(cfg, exp_name, cfg_dir, tmp_dir):
    # Get the pytorch lightning system and trainer. Pick the most recent best checkpoint.
    pl_system, trainer, checkpoint_found, load_ckpt_filepath = get_system_and_trainer(
        cfg=cfg,
        exp_name=exp_name,
        cfg_path=cfg_dir,
        tmp_dir=tmp_dir,
        load_checkpoint_type="best")

    if checkpoint_found:
        stdlog(__file__, f"Testing checkpoint at location {load_ckpt_filepath}.")
        print(f"()")

    # Train or continue training.
    trainer.test(pl_system, ckpt_path=load_ckpt_filepath)
