from spaghettini import quick_register


@quick_register
def get_pretraining_mode_kwarg(pl_system, num_pretraining_steps):
    """Return a dict (to be passed to forward method of a model) that tells whether to be in pretraining or not. """
    return dict(in_pretraining_mode=pl_system.global_step < num_pretraining_steps)
