#!/bin/bash
set -e

echo "train.py autoaug to sparse_1_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 1 --mode train --out_dir "sparse_1_baseaug" --auto_aug --cutout --load_ticket "sparse_1_baseaug/best_imp_2.ckpt" > "sparse_1_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_1_noaugticket.out" > "sparse_1_baseaug/logs_noaugticket.txt"

echo "train.py autoaug to sparse_0.5_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 0.5 --mode train --out_dir "sparse_0.5_baseaug" --auto_aug --cutout --load_ticket "sparse_0.5_baseaug/best_imp_6.ckpt" > "sparse_0.5_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_0.5_noaugticket.out" > "sparse_0.5_baseaug/logs_noaugticket.txt"

echo "train.py autoaug to sparse_0.2_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 0.2 --mode train --out_dir "sparse_0.2_baseaug" --auto_aug --cutout --load_ticket "sparse_0.2_baseaug/best_imp_6.ckpt" > "sparse_0.2_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_0.2_noaugticket.out" > "sparse_0.2_baseaug/logs_noaugticket.txt"

echo "train.py autoaug to sparse_0.1_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 0.1 --mode train --out_dir "sparse_0.1_baseaug" --auto_aug --cutout --load_ticket "sparse_0.1_baseaug/best_imp_15.ckpt" > "sparse_0.1_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_0.1_noaugticket.out" > "sparse_0.1_baseaug/logs_noaugticket.txt"

echo "train.py autoaug to sparse_0.02_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode train --out_dir "sparse_0.02_baseaug" --auto_aug --cutout --load_ticket "sparse_0.02_baseaug/best_imp_14.ckpt" > "sparse_0.02_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_0.02_noaugticket.out" > "sparse_0.02_baseaug/logs_noaugticket.txt"

echo "train.py autoaug to sparse_0.01_noaugticket"
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode train --out_dir "sparse_0.01_baseaug" --rand_aug --cutout --load_ticket "sparse_0.01_baseaug/best_imp_15.ckpt" > "sparse_0.01_noaugticket.out"
grep 'epoch:\|pruning state:\|remaining weight =' "sparse_0.01_noaugticket.out" > "sparse_0.01_baseaug/logs_noaugticket.txt"