import sys
import os
import os
sys.path.append(os.path.join(os.path.dirname(__file__), "../model"))

import numpy as np

from semantics import FactBaseSemanticsDataset
from bgp_semantics import BgpSemantics
from nutils import choose_random

class ConfiguredBgpSemantics:
    def __init__(self):
        self.s = BgpSemantics(labeled_networks=False)

    def sample(self, seed):
        s = np.random.RandomState(seed=seed)
        real_world_topology = False # np.random.random() < 0.2 # {True:0.3,False:0.7}
        num_networks = choose_random(list(range(4,8)), s)
        num_gateway_nodes = 3
        num_nodes = choose_random(range(16,24), s)

        sample_config_overrides = {
            "fwd": {
                "n": choose_random([8, 10, 12], s) # num paths of fwd predicates
            },
            "reachable": {
                "n": choose_random([4,5,6,7], s) # num reachable predicates
            },
            "trafficIsolation": {
                "n": choose_random(list(range(10,30)), s) # num trafficIsolation predicates
            }
        }

        seed = s.randint(0,1024*1024*1024)

        return self.s.sample(num_nodes=num_nodes, real_world_topology=real_world_topology, 
            num_networks=num_networks, predicate_semantics_sample_config_overrides=sample_config_overrides, 
            seed=seed, NUM_GATEWAY_NODES=num_gateway_nodes)

dataset = FactBaseSemanticsDataset(ConfiguredBgpSemantics(), "bgp-ospf-dataset-sub", num_samples=10*1024, tmp_directory="tmp-bgp-dataset")
print(len(dataset))
