#/bin/bash

#export PYTHONPATH="${PYTHONPATH}:/workspace/code"
#export GPU_ID=0,1
export GPU_ID=3

checkpoint_path=/mnt/efs/fs2/hzt/causal/Optimus/checkpoints/
output_path=/mnt/efs/fs2/hzt/causal/Optimus/outputs/
data_path=/mnt/efs/fs2/hzt/causal/Optimus/data/

## Yelp

debug=0

attribute_dim=50
if [ "$debug" -eq 1 ]
then
    TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
    #TEST_FILE=data/datasets/yelp_data_tst/small/test.txt
    TEST_FILE=data/datasets/yelp_data_tst/small/train.txt
    logging_steps=1
    per_gpu_train_batch_size=12
    per_gpu_eval_batch_size=12
    num_train_epochs=10
else
    #TRAIN_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_train.txt
    #TEST_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_dev.txt.sub.5594
    TRAIN_FILE=data/datasets/bias_yelp_data_tst/yelp_text_attrs_5_15_cor90_train.txt.reformat.len20
    TEST_FILE=data/datasets/bias_yelp_data_tst/yelp_text_attrs_5_15_cor90_dev.txt.reformat.sub.5771.len20
    logging_steps=2000
    save_steps=2000
    per_gpu_train_batch_size=8
    per_gpu_eval_batch_size=8
    num_train_epochs=10
fi

    #--eval_self_accuracy \

CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
    --eval_elbo \
    --beta 1.0 \
    --use_gumbel \
    --output_dir=${output_path}/finetune_lm/outputs-31250/s2-beta1-gsfixed-newmask-t05_w0_wr1_lr5e5_gumbel_samelen_bz8_bak/outputs-31250-448000/s2-beta1-cont-gsfixed-newmask-t07_w05_wr01_lr1e6_gumbel_samelen_bz8_bak \
    --learning_rate 1e-6 \
    --temperature=0.7 \
    --lambda_clas=0.5 \
    --lambda_recon=0.1 \
    --temperature_anneal_factor=1 \
    --temperature_anneal_iters=20000 \
    --checkpoint_dir=${output_path}/finetune_lm/outputs-31250/s2-beta1-gsfixed-newmask-t05_w0_wr1_lr5e5_gumbel_samelen_bz8_bak \
    --gloabl_step_eval 448000 \
    --attribute_dim $attribute_dim \
    --dataset Yelp \
    --encoder_model_type=bert \
    --encoder_model_name_or_path=bert-base-cased \
    --decoder_model_type=gpt2 \
    --decoder_model_name_or_path=gpt2 \
    --classifier_model_type=gpt2-clas \
    --classifier_model_name_or_path=gpt2 \
    --ratio_zero 0.5 \
    --ratio_increase 0.25 \
    --do_train \
    --fb_mode 1 \
    --dim_target_kl 0.5\
    --train_data_file=$TRAIN_FILE \
    --eval_data_file=$TEST_FILE \
    --num_train_epochs ${num_train_epochs} \
    --save_steps ${save_steps}\
    --logging_steps ${logging_steps} \
    --overwrite_output_dir \
    --block_size 100 \
    --length_weighted_loss \
    --use_pretrained_model \
    --use_pretrained_vae \
    --latent_size 768 \
    --evaluate_during_training \
    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}


## VAE from scratch

#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
#    --eval_elbo \
#    --beta 1.0 \
#    --use_gumbel \
#    --output_dir=${output_path}/finetune_lm/outputs-31250/s2-beta1-gsfixed-newmask-t05_w0_wr1_lr1e5_gumbel_samelen_bz8_bak \
#    --learning_rate 1e-5 \
#    --temperature=0.5 \
#    --lambda_clas=0.1 \
#    --lambda_recon=1 \
#    --temperature_anneal_factor=1 \
#    --temperature_anneal_iters=20000 \
#    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
#    --gloabl_step_eval 31250 \
#    --attribute_dim $attribute_dim \
#    --dataset Yelp \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --classifier_model_type=gpt2-clas \
#    --classifier_model_name_or_path=gpt2 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs ${num_train_epochs} \
#    --save_steps ${save_steps}\
#    --logging_steps ${logging_steps} \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
#    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}



## deterministic =============


#    #--checkpoint_dir=${output_path}/finetune_lm/bias_yelp_na50_10ep_bz16_vae/checkpoint-31250-279000 \
#
#    #--checkpoint_dir=${output_path}/finetune_lm/unbias_yelp_na50_10ep_bz16_vae/checkpoint-31250-324000 \
#    #--output_dir=${output_path}/finetune_lm/unbias_yelp_na50_10ep_bz16_vae/outputs-31250-324000/s2-baseunbias-unbias-gsfixed-newmask-t1_w05_wr01_lr1e5_gumbel_samelen_bz8_dtrm_bak \
#
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
#    --use_deterministic_connect \
#    --use_gumbel \
#    --output_dir=${output_path}/finetune_lm/bias_yelp_na50_10ep_bz16_vae/outputs-31250-279000/s2-gsfixed-newmask-t05_w1_wr01_lr1e6_gumbel_samelen_bz8_dtrm_bak \
#    --learning_rate 1e-6 \
#    --temperature=0.5 \
#    --lambda_clas=1 \
#    --lambda_recon=0.1 \
#    --temperature_anneal_factor=1 \
#    --temperature_anneal_iters=20000 \
#    --checkpoint_dir=${output_path}/finetune_lm/bias_yelp_na50_10ep_bz16_vae/checkpoint-31250-279000 \
#    --gloabl_step_eval 279000 \
#    --attribute_dim $attribute_dim \
#    --dataset Yelp \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --classifier_model_type=gpt2-clas \
#    --classifier_model_name_or_path=gpt2 \
#    --beta 0.0 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs ${num_train_epochs} \
#    --save_steps ${save_steps}\
#    --logging_steps ${logging_steps} \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
#    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}




### Before 02/2021
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
#    --use_deterministic_connect \
#    --output_dir=${output_path}/finetune_lm/yelp_na${attribute_dim}_10ep/outputs-31250-69000/bias/s2-t003_w01_gumbel_samelen_bz${per_gpu_train_batch_size}_dtrm_bak \
#    --checkpoint_dir=${output_path}/finetune_lm/yelp_na50_10ep/checkpoint-31250-69000 \
#    --gloabl_step_eval 69000 \
#    --attribute_dim $attribute_dim \
#    --dataset Yelp \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --classifier_model_type=gpt2-clas \
#    --classifier_model_name_or_path=gpt2 \
#    --beta 0.0 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs ${num_train_epochs} \
#    --save_steps ${save_steps}\
#    --logging_steps ${logging_steps} \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
#    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}
#
