%% clearing
clear all
close all
clc

%% problem/simulation parameters
h = 1e-4; %discretization stepsize (verlet method)
T = 40; %final time
K = floor(T/h); %total number of iterations integrator
k1= K/100; %beginning point for curve subset
k2 = k1 + floor(6*pi/h); % ending point for curve subset
t1 = h*k1;
t2 = h*k2;
%difference between time points is 2*pi


%% initialization
x = zeros(1,K);
v = zeros(1,K);
x(1) = 1;

%% simulation of NAG-ODE (= su, boyd, candes paper)
for i = 2:K
    v(:,i) = v(:,i-1) - h * 3/(h*i) * v(:,i-1) - x(:,i-1) * h;
    x(:,i) = x(:,i-1) + h * v(:,i-1);
end


%% cutting to the useful part of the trajectory (between k1 and k2)
x=x(:,k1:k2);
v=v(:,k1:k2);

Kdiff = size(x,2); %k2-k1+1

amplitudes = 0.0001*[-50:5:50]; %how big
actions = 0*amplitudes;

figure('Renderer', 'painters', 'Position', [10 10 1400 300]);

%% generating a maximum
for j = 1:length(amplitudes)
    %% generating perturbation (just a sin wave)
    %sinusoidal perturbation
    alpha = 2;
    pert = amplitudes(j)*(sin(h*(0:Kdiff-1)/2)).^alpha;
    d_pert = 0.5*alpha*amplitudes(j)*cos(h*(0:Kdiff-1)/2).*(sin(h*(0:Kdiff-1)/2)).^(alpha-1);    
    
    %Hadi perturbation
    %pert = amplitudes(j)*sin(h*(0:Kdiff-1))./((0:Kdiff-1)+cos(h*(0:Kdiff-1)));
    
    x_pert = x+pert;
    v_pert = v+d_pert;

    %% Computing the action for the two curves
    %computing f
    f = x.^2/2;

    %computing f (perturbed)
    f_pert = x_pert.^2/2;

    %computing lagrangians
    L = -(h*(k1:k2)).^3 .* ( f - 0.5*v.^2);
    L_pert = -(h*(k1:k2)).^3 .* ( f_pert - 0.5*v_pert.^2);

    %computing actions
    S = h*sum(L);
    S_pert = h*sum(L_pert);
    actions(j)=S_pert-S;
end

subplot(1,4,1)
plot(t1:h:t2,x,'linewidth',3);hold on
plot(t1:h:t2,70*pert,'-','linewidth',3);
xlabel('time','Fontsize',20,'Interpreter','latex')
ylabel('value','Fontsize',20,'Interpreter','latex')
title('$\sin^2(t)$ perturbation','Fontsize',20,'Interpreter','latex')
legend('AGD-ODE','perturbation','Fontsize',20,'Interpreter','latex')
grid on

subplot(1,4,2)
plot(amplitudes,actions,'linewidth',3,'color',[0.667 0.569 0.157])
title('$\sin^2(t)$ perturbation','Fontsize',20,'Interpreter','latex')
xlabel('Size perturbation','Fontsize',20,'Interpreter','latex')
ylabel('$\Delta J$ w.r.t. Nesterov','Fontsize',20,'Interpreter','latex')
grid on



%% generating a minimum
for j = 1:length(amplitudes)
    %% generating perturbation (just a sin wave)
    %sinusoidal perturbation
    alpha = 10;
    pert = amplitudes(j)*(sin(h*(0:Kdiff-1)/2)).^alpha;
    d_pert = 0.5*alpha*amplitudes(j)*cos(h*(0:Kdiff-1)/2).*(sin(h*(0:Kdiff-1)/2)).^(alpha-1);    
    
    %Hadi perturbation
    %pert = amplitudes(j)*sin(h*(0:Kdiff-1))./((0:Kdiff-1)+cos(h*(0:Kdiff-1)));
    
    x_pert = x+pert;
    v_pert = v+d_pert;

    %% Computing the action for the two curves
    %computing f
    f = x.^2/2;

    %computing f (perturbed)
    f_pert = x_pert.^2/2;

    %computing lagrangians
    L = -(h*(k1:k2)).^3 .* ( f - 0.5*v.^2);
    L_pert = -(h*(k1:k2)).^3 .* ( f_pert - 0.5*v_pert.^2);

    %computing actions
    S = h*sum(L);
    S_pert = h*sum(L_pert);
    actions(j)=S_pert-S;
end

subplot(1,4,3)
plot(t1:h:t2,x,'linewidth',3);hold on
plot(t1:h:t2,70*pert,'-','linewidth',3);
xlabel('time','Fontsize',20,'Interpreter','latex')
ylabel('value','Fontsize',20,'Interpreter','latex')
title('$\sin^{10}(t)$ perturbation','Fontsize',20,'Interpreter','latex')
legend('AGD-ODE','perturbation','Fontsize',20,'Interpreter','latex')
grid on

subplot(1,4,4)
plot(amplitudes,actions,'linewidth',3,'color',[0.667 0.569 0.157])
title('$\sin^{10}(t)$ perturbation','Fontsize',20,'Interpreter','latex')
xlabel('Size perturbation','Fontsize',20,'Interpreter','latex')
ylabel('$\Delta J$ w.r.t. Nesterov','Fontsize',20,'Interpreter','latex')
grid on

saveas(gcf,['nesterov_saddle'],'epsc');

