from scipy.optimize import minimize
import math
import numpy as np
import matplotlib.pyplot as plt
import random as rn
import time



def  Norm(x):
	squares = [y**2 for y in x]
	a = sum(squares)
	return a**(1/2) 


def  pNorm(x):
	powers = [np.abs(y)**p for y in x]
	a = sum(powers)
	return a**(1/p) 


def dot(x,y):
	return sum(   [x[i]*y[i] for i in range(0,len(x)) ]   )  



def dotCC(x,CCost):
	#print("starting dotCC")
	#print("x = ", x)
	#print("CCost =", CCost)
	return sum(   [x[i]*CCost[i] for i in range(0,d*d) ]   ) 



def ExpectedLoss(x):
	return sum(   [x[i]*Expectation[i] for i in range(0,len(x)) ]   ) 


def Distance(x,y): 		
	a = sum(  [ (x[i]-y[i])**2  for i in range(0,len(x)) ]   )  	# takes x as vector
	return a**(1/2)



def SchattenNorm(x):                                   			# Schatten norm of matrix x with parameter p, takes x as vector
	x = np.reshape( x,(d,d) ) 	
	sv = np.linalg.svd(x)[1]
	a =  sum( [ np.abs(y)**p  for y in sv  ])
	return a**(1/p)




def regret(Costs,Actions): 
	
	Regret = [0]
	cons= ({'type': 'ineq', 'fun': lambda x: -SchattenNorm(x) +1})  
	global CCcost	
	CCost = np.array([0]*d*d)
	Benchmark = np.array([0]*d*d)
	for n in range(1, len(Actions)):
		CCost = np.add(CCost, Costs[n])
		fun = lambda x: dotCC(x,CCost)
		#print("CCost = ",CCost )
		#print("dotCC([0,0,0,1]) = ", dotCC([0,0,0,1]))
		res = minimize( fun, Benchmark, constraints=cons)
		Benchmark = list(res.x)
		#print("Benchmark", n, " = \n", np.reshape( Benchmark ,(d,d)))
		r = [ dot( Actions[i], Costs[i] ) - dot( Benchmark, Costs[i] ) for i in range(0,n)]
		R = sum(r)
		Regret = Regret + [R]
	return Regret


def Subgradient(Costs,eta): 

	CCost = np.array([0]*d*d)    # cumulative cost
	y = np.array( [0] )
	Actions = [ [0]*d*d]
	#print("Actions = ", Actions)
	Losses =   [0]  
	for i in range(1,N):
		#print("New cost = \n", np.reshape(   [Costs [i-1] ]  , (d,d) ) )
		CCost = np.add(CCost, Costs[i-1])
		#print("CumulativeCost = \n",  np.reshape(   [CCost ]  , (d,d) ) )
		y = -eta*CCost*(1/np.sqrt(i))
		#print("y =  \n",np.reshape(   [y]  , (d,d) ) )
		cons = ({'type': 'ineq', 'fun': lambda x: -SchattenNorm(x) +1})  
		fun = lambda x: Distance(x,y)	
		res = minimize( fun, Actions[i-1], constraints=cons,  tol = 0.0001)
		X = list(res.x)
		#print("Action = \n", np.round( np.reshape(   [X ]  , (d,d) ),3), "\n" )
		#print("Schatten norm =  \n", np.round( SchattenNorm(X),3) )
		#print("SVD =  \n", np.linalg.svd(np.reshape(   [X]  , (d,d) ) )[0][0])
		Actions = Actions + [X]

	return [Actions, CCost]

def ExpectedCosts(r):	                       
	a = [ (x/(d-1))**r for x in range(0,d)] 
	norm = Norm(a)	
	a = [x/norm for x in a]
	a = np.diag(a)
	a = np.reshape(a,(1,d*d))
	return a[0]



def Noise1(NoiseSize):
	N = [rn.choice([-1,1]) for x in range(0,d*d)]
	norm = Norm(N)
	N =  [NoiseSize*x/norm for x in N]
	N =  np.reshape(N,(d,d))
	return np.reshape(N,(1,d*d))[0]


def Noise2(NoiseSize):
	N = np.zeros((d,d)) 
	i = rn.choice(range(0,d))
	R = [  rn.choice([-1,1]) for j in range(0,d)]
	norm = Norm(R)
	R = [NoiseSize*x/norm for x in R]
	N[i] = R
	return np.reshape(N,(1,d*d))[0]


def Noise3(NoiseSize):
	N = np.zeros((d,d)) 
	i = rn.choice(range(0,d))
	j = rn.choice(range(0,d))
	N[i,j] = rn.choice([-1,1])  
	return np.reshape(N,(1,d*d))[0]

	
def CostHistory(r):
	a = ExpectedCosts(r)
	H = [np.add(a,Noise1(NoiseSize)) for x in range(0,N)] # Change to Noise2 or Noise3
	return H
 
start_time = time.time()

 

NoiseSize = 1

p = 1.5

r = 0

d = 5

N = 100
  
eta = 1

S = 10


CCost = np.array([0]*d*d)

print("\n \n \n \n \n" )
 
 
 
for p in [2,1.5,1.25]:  # use this to loop over parameters
 
	Total = [0]*N
	print("p = ", p)
	for n in range (0,S):
		
		print("Starting Sample Number", n)		
		print("Expected Cost = \n",   np.reshape(   [ExpectedCosts(r) ]  , (d,d) ) , "\n")
		C = CostHistory(r)
		X = Subgradient(C,1)[0]
		#print("X = ", X)
		#print("C = ", C)
		R = regret(C,X)
		Total = [Total[i] + R[i] for i in range(0,N) ]
	
	Average = [x/S for x in Total]
	plt.plot(Average,label = " p = "+str(p))






 

end_time = time.time()
print("\n execution time = ",    end_time-start_time, "\n")

#plt.title("dimension = " +str(d)+", p = "+str(p)+", Samples = " +str(S)+ ", r = " +str(r))
plt.title("d = " +str(d)+", r = "+str(r)+", Samples = " +str(S)+", Noise Type  = (1)" )
plt.ylabel("Regret")
plt.xlabel("Number of turns")
plt.legend(loc = 'lower right')
plt.show()
 
 
