%% Single-Trial Measures of Coordinated Ensemble Spiking
clear all;
clc;

%% Load Data
load('SimData.mat');
L = size(n,1);
T = size(n,2);

%%
W=250;
K=T/W;

alpha = 0.05;
showfig = 1;

%%% Pearson Correlation
[rhoMean, CI_UP_Mean, CI_LO_Mean, rho, CI_upper, CI_lower] = SynchCorrelation(n, W, alpha, showfig);

%%% Spiking Regularity
[coeffVarMean, coeffVar, ISI] = SpikeRegularity(n, W, showfig);

%%
clear all;
clc;

load('SimResults_HistoryDependent.mat');
clearvars -except lambda_star lambda incl_idx ord_idx

%%% Avg. CIF Difference
showfig = 1;
[rhoR, rhoR_CI_UP, rhoR_CI_LO, rho] = SynchCIF(lambda_star, lambda, incl_idx, ord_idx, showfig);
