import setuptools
import os

with open("README.md", "r") as fh:
    long_description = fh.read()

with open(os.path.join("psynet", 'VERSION')) as version_file:
    version = version_file.read().strip()

setuptools.setup(
    name="psynet", # Replace with your own username
    version="0.11.0",
    author="anonymized",
    author_email="anonymized",
    description="Utility functions for Dallinger experiments",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="anonymized/psynet",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.7.0',
    include_package_data=True,
    install_requires=["dallinger", "datetime", "flask", "importlib_resources", "pandas", "rpdb", "progress", "scipy", "statsmodels"]
)

# python3.7 setup.py sdist bdist_wheel
