#!/bin/bash

mkdir -p log

stage=4
ngpu=0
other_otps=

blayers=6; bunits=2048; bprojs=2048; preprocess_conf="conf/preprocess.conf"; other_opts="--stats-file fbank/tr_spatialized_all/cmvn.ark"

train_config=conf/train_multispkr_transformer_front_backend.yaml

log=log/log.stage${stage}

qsub -cwd -o ${log} -j y run.sh \
    --backend pytorch \
    --stage ${stage} \
    --ngpu ${ngpu} \
    --dumpdir data \
    --blayers ${blayers} \
    --bunits ${bunits} \
    --bprojs ${bprojs} \
    --preprocess-config ${preprocess_conf} \
    --train-config ${train_config} \
    ${other_opts}
