# set working directory to the one containing this file

##############################
# CR 3 - Nazari 51

or_tools_51 = read_csv("paper_data/rl_best/or-tools/cities_51_capacity_40_instances_1000_result.csv") %>%
  select(c(name, distance)) %>%
  rename(or_tools = distance)

rl_51 = read_csv("paper_data/camera_ready_data/cr3_nazari51_h16_result.csv") %>%
  mutate(`hidden-nodes` = ifelse(is.na(`hidden-nodes`), 0, `hidden-nodes`))

rl_51 %>%
  mutate(hidden_nodes = as.factor(`hidden-nodes`)) %>%
  left_join(or_tools_51) %>%
  mutate(gap = (distance - or_tools) / or_tools) %>%
  group_by(iteration) %>%
  summarize(meandist = mean(distance), stddist = sd(distance), count = n(),
            meangap = mean(gap), stdgap = sd(gap)) %>%
  View()
# the new average is 10.64 +/- 0.04, compared to 10.62 for Kool et al.
# in the rebuttal, we indicated 10.69 +/- 0.09, so things are in line

##############################
# CR 1/2 - CVRPLIB

cvrplib = read_csv("paper_data/camera_ready_data/cr1_cvrplib_linear_result.csv") %>%
  rbind(read_csv("paper_data/camera_ready_data/cr2_cvrplib_h16_result.csv"))

names = read.csv("paper_data/rl_best/cvrplib/cvrplib_instance_ordering.csv", header=F) %>%
  mutate(name = paste("instance", as.numeric(rownames(names)) - 1,
                      sep = "_")) %>%
  separate(V1, sep=".vrp.bi", into = c("V1", "tmp")) %>%
  select(-c(tmp, V2)) %>%
  separate(V1, sep="cvrplib/", into = c("tmp", "V1")) %>%
  select(-tmp) %>%
  separate(V1, sep="n", into = c("tmp", "V1")) %>%
  select(-tmp) %>%
  separate(V1, sep="-k", into = c("n", "k")) %>%
  mutate_at(c("n", "k"), as.numeric)
  
cvrplib_or_tools = read_csv("paper_data/rl_best/cvrplib/cvrplib_ab_result_gls_300.csv") %>%
  select(name, distance) %>%
  rename(or_tools = distance)

cvrplib_or_tools_fast = read_csv("paper_data/rl_best/cvrplib/cvrplib_ab_result_fast.csv") %>%
  select(name, distance) %>%
  rename(or_tools_fast = distance)

cvrplib  = cvrplib %>%
  left_join(names) %>%
  left_join(cvrplib_or_tools) %>%
  left_join(cvrplib_or_tools_fast) %>%
  mutate(gap = (distance - or_tools)/or_tools,
         gap_fast = (or_tools_fast - or_tools)/or_tools)

cvrplib %>%
  filter(iteration == 100) %>%
  filter(`hidden-nodes` == 16) %>%
  ggplot() +
  aes(x = n, y = gap) +
  geom_point()

cvrplib %>%
  filter(iteration == 100) %>%
  filter(gap < 0) %>%
  View()

cvrplib %>%
  mutate(hidden_nodes = (`hidden-nodes`)) %>%
  filter(hidden_nodes == 16 | is.na(hidden_nodes)) %>%
  mutate(hidden_nodes = as.factor(ifelse(is.na(hidden_nodes), 0, hidden_nodes))) %>%
  group_by(iteration, hidden_nodes) %>%
  summarize(meangap = mean(gap), stdgap = sd(gap)/sqrt(n())) %>%
  View()
  ungroup() %>%
  #rbind(best_cvrplib) %>%
  ggplot() +
  aes(x = iteration, y = meangap, group = hidden_nodes,
      color = hidden_nodes, fill = hidden_nodes,
      linetype = hidden_nodes,
      ymin = meangap - stdgap, ymax = meangap + stdgap) +
  geom_line(size = 2) +
  geom_ribbon(alpha = 0.2) +
  theme(legend.position = c(0.75, 0.75), legend.text = element_text(size=24),
        legend.title = element_text(size=24), axis.title = element_text(size=24), 
        axis.text = element_text(size=24),
        legend.background = element_blank(),
        legend.box.background = element_rect(color="black"),
        panel.border = element_blank(),
        panel.background = element_blank(),
        panel.grid.major = element_line(colour = "gray", linetype="dashed"),
        panel.grid.minor = element_blank(),
        axis.line = element_line(colour = "black"),
        legend.spacing = unit(2, "line"),
        legend.key.height = unit(2, "line"),
        legend.key.width = unit(3, "line")) +
  scale_y_continuous(lim = c(0, 0.32), labels = c("0%", "10%", "20%", "30%"), name = "Average gap with OR-Tools (300s)") +
  scale_fill_brewer(palette = "Set2", name = "Hidden nodes") +
  scale_color_brewer(palette = "Set2") +
  labs(color = "Hidden nodes", linetype = "Hidden nodes", group = "Hidden nodes")
# ggsave("paper_plots/cr/cvrplib.png")

##############################
# Rebuttal 6/7 - linear without lower bounds

# linear with no bounds
rebuttal6 = read_csv("paper_data/camera_ready_data/rebuttal6_linear_no_lbs_51_result.csv")
# linear with bounds
rebuttal6 = rebuttal6 %>%
  rbind(read_csv("paper_data/rebuttal/scrape_thurs_aug_13_1pm/rebuttal1_linear_warm_start_scrape.csv"))

rebuttal6 %>%
  group_by(iteration) %>%
  summarize(count = n())

rebuttal6 %>%
  filter(iteration <= 90) %>%
  left_join(or_tools_51) %>%
  mutate(gap = (distance - or_tools) / or_tools) %>%
  mutate(lb = `lb-out-and-back`) %>%
  group_by(lb, iteration) %>%
  summarize(count = n(), meangap = mean(gap), stdgap = sd(gap)/sqrt(n())) %>%
  ungroup() %>%
  ggplot() +
  aes(x = iteration, y = meangap, group=lb, color = lb, fill = lb, linetype=lb,
      ymin = meangap - stdgap, ymax = meangap + stdgap) %>%
  geom_ribbon(alpha = 0.2) +
  aes(x = iteration, y = meangap, color = lb, group=lb, linetype = lb) +
  geom_line(size = 2) +
  scale_color_brewer(palette = "Set2") +
  scale_fill_brewer(palette = "Set2") +
  theme(legend.position = c(0.75, 0.75), legend.text = element_text(size=24),
        legend.title = element_text(size=24), axis.title = element_text(size=24), 
        axis.text = element_text(size=24),
        legend.background = element_blank(),
        legend.box.background = element_rect(color="black"),
        panel.border = element_blank(),
        panel.background = element_blank(),
        panel.grid.major = element_line(colour = "gray", linetype="dashed"),
        panel.grid.minor = element_blank(),
        axis.line = element_line(colour = "black"),
        legend.spacing = unit(2, "line"),
        legend.key.height = unit(2, "line"),
        legend.key.width = unit(3, "line"))

# rebuttal7
or_tools_21 = read_csv("paper_data/rl_best/or-tools/cities_21_capacity_30_instances_1000_result.csv") %>%
  separate(name, c("name.1", "name.2"), sep="_number_") %>%
  mutate(name = paste("instance_", name.2, sep="")) %>%
  select(c(name, distance)) %>%
  rename(or_tools = distance)

rebuttal7 = read_csv("paper_data/camera_ready_data/rebuttal7_linear_no_lbs_21_result.csv") %>%
  rbind(read_csv("paper_data/rl_best/arch/cities_21_arch_scrape.csv")) %>%
  left_join(or_tools_21) %>%
  mutate(gap = (distance - or_tools) / or_tools) %>%
  filter(is.na(`hidden-nodes`)) %>%
  filter(`lasso-weight` == 0.0)
  
rebuttal7 %>%
  mutate(lb = `lb-out-and-back`) %>%
  group_by(lb, iteration) %>%
  summarize(count = n(), meangap = mean(gap), stdgap = sd(gap)/sqrt(n())) %>%
  ungroup() %>%
  ggplot() +
  aes(x = iteration, y = meangap, group=lb, color = lb, fill = lb, linetype=lb,
      ymin = meangap - stdgap, ymax = meangap + stdgap) %>%
  geom_ribbon(alpha = 0.2) +
  aes(x = iteration, y = meangap, color = lb, group=lb, linetype = lb) +
  geom_line(size = 2) +
  scale_color_brewer(palette = "Set2") +
  scale_fill_brewer(palette = "Set2") +
  theme(legend.position = c(0.75, 0.75), legend.text = element_text(size=24),
        legend.title = element_text(size=24), axis.title = element_text(size=24), 
        axis.text = element_text(size=24),
        legend.background = element_blank(),
        legend.box.background = element_rect(color="black"),
        panel.border = element_blank(),
        panel.background = element_blank(),
        panel.grid.major = element_line(colour = "gray", linetype="dashed"),
        panel.grid.minor = element_blank(),
        axis.line = element_line(colour = "black"),
        legend.spacing = unit(2, "line"),
        legend.key.height = unit(2, "line"),
        legend.key.width = unit(3, "line"))


