from tf_utils import read_hdf5
import sys
import numpy as np

di = read_hdf5(sys.argv[1])
num_kernel_params = 0
for name, array in di.items():
    if array.ndim in [2, 4]:
        num_kernel_params += array.size
    print(name, array.shape, np.mean(array), ' positive {}, negative {}, zeros {}'.format(np.sum(array > 0), np.sum(array < 0), np.sum(array == 0)))
print('number of kernel params: ', num_kernel_params)
