package clust;

import java.util.ArrayList;
import java.util.List;

import base.Line;
import base.Point;
import ilog.concert.IloIntExpr;
import ilog.concert.IloIntVar;
import ilog.cplex.IloCplex;

public class Clustering
{
    private Clustering() {}
    public static double evaluate(List<WeightedPoint> X, List<Point> C, Objective O)
    {
        double sum = 0;
        for (WeightedPoint p : X)
        {
            sum += p.weight * O.value(Point.dist(p.data, C));
        }
        return sum;
    }
    
    // F[color][cluster]
    public static double evaluate(List<WeightedPoint> X, int[][] F, List<Point> C, Objective O)
    {
    	int numCol = F.length;
    	int k = C.size();
    	int n = X.size();
    	
    	double res = 0;
		try
		{
			IloCplex cplex = new IloCplex();
			// cplex.setOut(null);
			// cplex.setWarning(null);
			
			int[][] id = new int[n][k];
			int nVar = 0;
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < k; j++)
				{
					id[i][j] = nVar++;
				}
			}
			int[] lb = new int[nVar];
			int[] ub = new int[nVar];
			
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < k; j++)
				{
					lb[id[i][j]] = 0;
					ub[id[i][j]] = (int)Math.round(X.get(i).weight);
				}
			}

			IloIntVar[] x = cplex.intVarArray(nVar, lb, ub);

			// build objective
			double[] objCoe = new double[nVar];
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < k; j++)
				{
					objCoe[id[i][j]] = O.value(Point.dist(X.get(i).data, C.get(j)));
					// lpw.plus(getEdgeVar(u, e.u), e.cost);
				}
			}
			cplex.addMinimize(cplex.scalProd(x, objCoe));
			
			for (int i = 0; i < n; i++)
			{
				ArrayList<IloIntExpr> term = new ArrayList<IloIntExpr>();
				for (int j = 0; j < k; j++)
				{
					term.add(x[id[i][j]]);
				}
				IloIntExpr[] tmp = new IloIntExpr[term.size()];
				tmp = term.toArray(tmp);
				cplex.addEq(cplex.sum(tmp), (int)Math.round(X.get(i).weight));
			}
			
			for (int i = 0; i < numCol; i++)
			{
				for (int j = 0; j < k; j++)
				{
					ArrayList<IloIntExpr> term = new ArrayList<IloIntExpr>();
					for (int t = 0; t < n; t++)
					{
						for (Integer cc : X.get(t).cg.c)
						{
							if (cc == i)
							{
								term.add(x[id[t][j]]);
							}
						}
					}
					IloIntExpr[] tmp = new IloIntExpr[term.size()];
					tmp = term.toArray(tmp);
					cplex.addEq(cplex.sum(tmp), F[i][j]);
				}
			}
			/*int consCount = 0;
			for (Object u : vertSet)
			{
				ArrayList<FlowEdgeEntry> adj = null;
				double balance = 0;
				if (u.equals(source) || u.equals(sink))
				{
					adj = u.equals(source) ? edge.get(u) : revEdge.get(u);
					for (FlowEdgeEntry e : adj)
					{
						balance += e.cap;
					}
					double sign = u.equals(source) ? -1.0 : 1.0;
					balance *= sign;
				}
				ArrayList<IloNumExpr> term = new ArrayList<IloNumExpr>();
				// LPWizardConstraint cons = lpw.addConstraint("c" + consCounter, balance, "=");
				adj = revEdge.get(u);
				for (FlowEdgeEntry e : adj)
				{
					term.add(cplex.prod(1.0, x[edgeMap.get(getEdgeVar(e.u, u))]));
					// cons.plus(getEdgeVar(e.u, u), 1.0);
				}
				adj = edge.get(u);
				for (FlowEdgeEntry e : adj)
				{
					term.add(cplex.prod(-1.0, x[edgeMap.get(getEdgeVar(u, e.u))]));
					//cons.plus(getEdgeVar(u, e.u), -1.0);
				}
				IloNumExpr[] expr = new IloNumExpr[term.size()];
				for (int i = 0; i < term.size(); i++)
				{
					expr[i] = term.get(i);
				}
				cplex.addEq(cplex.sum(expr), balance, "c" + consCount);
				consCount++;
			}*/
			// solve		
			cplex.solve();
			res = cplex.getObjValue();
			cplex.end();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return res;
    }
    
    // F[color][cluster]
    /*public static double evaluate(List<WeightedPoint> X, int[][] F, List<Point> C, Objective O)
	{
		HashMap<Integer, List<WeightedPoint>> colorMap = WeightedPoint.colorMap(X);
		double sum = 0;
		for (Integer c : colorMap.keySet())
		{
			sum += evaluate(colorMap.get(c), F[c], C, O);
		}
		return sum;
	}
	
	private static double evaluate(List<WeightedPoint> X, int[] F, List<Point> C, Objective O)
	{
		int k = C.size();
		int n = X.size();
		// System.out.println(WeightedPoint.totalWeight(X));

		MinCostFlowSolver sol = new MinCostFlowSolver();
		sol.addVert("source");
		sol.addVert("sink");
		for (int i = 0; i < n; i++)
		{
			sol.addVert("point"+i);
		}
		for (int i = 0; i < k; i++)
		{
			sol.addVert("cluster"+i);
		}
		sol.finishAddingVert();

		// source -> X
		for (int i = 0; i < n; i++)
		{
			sol.addEdge("source", "point" + i, 0, X.get(i).weight);
		}
		// X -> cluster
		for (int i = 0; i < n; i++)
		{
			for (int j = 0; j < k; j++)
			{
				sol.addEdge("point" + i,
						"cluster" + j,
						O.value(Point.dist(X.get(i).data, C.get(j))),
						WeightedPoint.totalWeight(X) + 1);
			}
		}
		// cluster -> sink
		for (int i = 0; i < k; i++)
		{
			sol.addEdge("cluster" + i, "sink", 0, F[i]);
		}
		return sol.LPSolveCplex("source", "sink");
	}*/
	
	public static List<WeightedPoint>[] getClusters(List<WeightedPoint> X, List<Point> C)
	{
		int m = C.size();
		ArrayList<WeightedPoint>[] res = new ArrayList[m];
		for (int i = 0; i < m; i++)
		{
			res[i] = new ArrayList<WeightedPoint>();
		}
		for (WeightedPoint wp : X)
		{
			double min = Double.MAX_VALUE;
			int id = -1;
			for (int i = 0; i < m; i++)
			{
				double d = Point.dist(wp.data, C.get(i));
				if (d < min)
				{
					min = d;
					id = i;
				}
			}
			res[id].add(wp);
		}
		return res;
	}
	
	public static List<WeightedPoint>[] getLineClustering(List<WeightedPoint> X, List<Line> lineCenters)
	{
		int m = lineCenters.size();
		ArrayList<WeightedPoint>[] res = new ArrayList[m];
		for (int i = 0; i < m; i++)
		{
			res[i] = new ArrayList<WeightedPoint>();
		}
		for (WeightedPoint wp : X)
		{
			double min = Double.MAX_VALUE;
			int id = -1;
			for (int i = 0; i < m; i++)
			{
				if (lineCenters.get(i) == null)
					continue;
				double dist = Line.dist(wp.data, lineCenters.get(i));
				if (dist < min)
				{
					min = dist;
					id = i;
				}
			}
			res[id].add(wp);
		}
		return res;
	}
}
