import os
from tqdm import tqdm
from utils import get_all_files


root1 = '/private/home/hengyuan/rts-replays/replays-float-xy/replays'
root2 = '/private/home/hengyuan/rts-replays/data3'

files1 = sorted(get_all_files(root1, 'rep.p0.json'))
files2 = sorted(get_all_files(root2, 'rep.p0.json'))


if len(files1) != len(files2):
    print('error: file list not the same')
    print(len(files1), len(files2))
    new_files1 = []
    for f in files1:
        f2 = f.replace(root1, root2)
        if f2 not in files2:
            print('not found:', f)
        else:
            new_files1.append(f)
    # assert False
    files1 = new_files1

print('list match', len(files1), len(files2))


for f1, f2 in tqdm(zip(files1, files2)):
    ff1 = f1[len(root1):]
    ff2 = f2[len(root2):]
    if ff1 != ff2:
        print('error: file name mismatch')
        print('\t', f1)
        print('\t', f2)

    s1 = open(f1, 'r').readlines()
    s2 = open(f2, 'r').readlines()
    if len(s1) != len(s2) - 1:
        print('error: content mismatch:')
        print('\t', f1)
        print('\t', f2)
        continue
    s1 = s1[:-2]
    s2 = s2[:-3] # + s2[-2:]

    if s1 != s2:
        print('error: content mismatch:')
        print('\t', f1)
        print('\t', f2)
        for i, (l1, l2) in enumerate(zip(s1, s2)):
            if l1 != l2:
                import pdb
                pdb.set_trace()
