#!/bin/bash
python train_coach.py \
  --train_dataset $DATA_ROOT/train.json \
  --val_dataset $DATA_ROOT/val.json \
  --inst_dict_path $DATA_ROOT/dict.pt \
  --emb_field_dim 32 \
  --prev_cmd_dim 64 \
  --num_conv_layers 3 \
  --num_post_layers 1 \
  --conv_hid_dim 256 \
  --army_out_dim 128 \
  --other_out_dim 128 \
  --money_hid_layer 1 \
  --conv_dropout 0.0 \
  --word_emb_dim 128 \
  --word_emb_dropout 0.25 \
  --inst_hid_dim 256 \
  --count_hid_dim 256 \
  --count_hid_layers 2 \
  --glob_dropout 0.5 \
  --coach_type rnn \
  --model_folder saved_model/instruction_rnn \
  --batch_size 100 \
  --gpu 0 \
  --grad_clip 0.5 \
  --lr 0.002 \
  --optim adamax \
  --epochs 50 \
  --num_pos_inst 500 \
  --num_neg_inst 500 \
  --pos_dim 16 \
  --prev_cmd_rnn 1 \
  --seed 9 \
