# Hierarchical Decision Making by Generating and Following Natural Language Instructions
## Supporting code

### Dependencies
We implement our models in Python 3.6 using Numpy 1.16.0 and PyTorch 1.1.0, thus the following packages need to be installed:
```
pip install numpy
pip intall torch
pip install tqdm
pip install tb-nightly
pip install future
pip install Pillow
```



### Dataset
First, download `dataset.tar.gz` using http://bit.ly/2VL9lg6 and put in the root folder of this project. Then unpack it by running:
```
tar -xzf dataset.tar.gz
```
This will create the `dataset` folder, with the following files:
```
dict.pt    # pickle archive of behavior_clone/inst_dict.py, which contains the words and instructions dictionaries.
dev.json   # a json dump of a small training dataset useful for debugging.
train.json # a json dump of a large training dataset.
val.json   # a json dump of a validation dataset.
```


### Training Executor Model
From the root folder of this project run:
```
cd behavior_clone
```
Then, to train the RNN based executor model, run:
```
DATA_ROOT=../dataset sh scripts/train_executor_rnn.sh
```

For the BOW executor, run:
```
DATA_ROOT=../dataset sh scripts/train_executor_bow.sh
```

To debug with a smaller dataset, run:
```
DATA_ROOT=../dataset sh scripts/train_executor_zero.sh 
```

### Training Instructor Model
To train the RNN instructor model, run the following commands from the root of the project:
```
cd behavior_clone

DATA_ROOT=../dataset sh scripts/train_instructor_rnn.sh
```
