#!/bin/bash


id=0

for t in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
do
    CUDA_VISIBLE_DEVICES=$id \
        python3.6 main_gumbel.py \
        --num_per_class 40 \
        --dev_num_per_class 2 \
        --finetune_generator 1 \
        --classifier_learning_rate 4e-5 \
        --finetune_epochs 30 \
        --min_finetune_epochs 10 \
        --batch_size 8 \
        --name "gtune_gumbel_${id}_${t}" \
        --result_fn "results_gumbel_${id}.csv" \
        --generator_learning_rate 4e-5 \
        --softmax_temperature 1 \
        --classifier_pretrain_epochs 1 \
        --num_aug 4
done
