from typing import Text, Dict, Tuple, Sequence, Optional, Set, overload
from onnx import AttributeProto


class OpSchema(object):
    @property
    def file(self) -> Text: ...
    @property
    def line(self) -> int: ...
    @property
    def support_level(self) -> SupportType: ...
    @property
    def doc(self) -> Optional[Text]: ...
    @property
    def since_version(self) -> int: ...
    @property
    def deprecated(self) -> bool: ...
    @property
    def domain(self) -> Text: ...
    @property
    def name(self) -> Text: ...
    @property
    def min_input(self) -> int: ...
    @property
    def max_input(self) -> int: ...
    @property
    def min_output(self) -> int: ...
    @property
    def max_output(self) -> int: ...
    @property
    def attributes(self) -> Dict[Text, Attribute]: ...
    @property
    def inputs(self) -> Sequence[FormalParameter]: ...
    @property
    def outputs(self) -> Sequence[FormalParameter]: ...
    @property
    def type_constraints(self) -> Sequence[TypeConstraintParam]: ...
    @property
    def has_type_and_shape_inference_function(self) -> bool: ...

    @staticmethod
    def is_infinite(v: int) -> bool: ...

    def consumed(self, schema: OpSchema, i: int) -> Tuple[UseType, int]: ...

    class TypeConstraintParam(object):
        @property
        def type_param_str(self) -> Text: ...
        @property
        def description(self) -> Text: ...
        @property
        def allowed_type_strs(self) -> Sequence[Text]: ...

    class FormalParameterOption(object):
        Single: 'OpSchema.FormalParameterOption' = ...
        Optional: 'OpSchema.FormalParameterOption' = ...
        Variadic: 'OpSchema.FormalParameterOption' = ...

    class FormalParameter(object):
        @property
        def name(self) -> Text: ...
        @property
        def types(self) -> Set[Text]: ...
        @property
        def typeStr(self) -> Text: ...
        @property
        def description(self) -> Text: ...
        @property
        def option(self) -> OpSchema.FormalParameterOption: ...

    class AttrType(object):
        FLOAT: 'OpSchema.AttrType' = ...
        INT: 'OpSchema.AttrType' = ...
        STRING: 'OpSchema.AttrType' = ...
        TENSOR: 'OpSchema.AttrType' = ...
        GRAPH: 'OpSchema.AttrType' = ...
        FLOATS: 'OpSchema.AttrType' = ...
        INTS: 'OpSchema.AttrType' = ...
        STRINGS: 'OpSchema.AttrType' = ...
        TENSORS: 'OpSchema.AttrType' = ...
        GRAPHS: 'OpSchema.AttrType' = ...

    class Attribute(object):
        @property
        def name(self) -> Text: ...
        @property
        def description(self) -> Text: ...
        @property
        def type(self) -> OpSchema.AttrType: ...
        @property
        def default_value(self) -> AttributeProto: ...
        @property
        def required(self) -> bool: ...


    class SupportType(int):
        COMMON: 'OpSchema.SupportType' = ...
        EXPERIMENTAL: 'OpSchema.SupportType' = ...


    class UseType(object):
        DEFAULT: 'OpSchema.UseType' = ...
        CONSUME_ALLOWED: 'OpSchema.UseType' = ...
        CONSUME_ENFORCED: 'OpSchema.UseType' = ...


def has_schema(op_type: Text) -> bool: ...
def schema_version_map() -> Dict[Text, Tuple[int, int]]: ...
@overload
def get_schema(op_type: Text, max_inclusive_version: int, domain: Text = "") -> OpSchema: ...
@overload
def get_schema(op_type: Text, domain: Text = "") -> OpSchema: ...
def get_all_schemas() -> Sequence[OpSchema]: ...
def get_all_schemas_with_history() -> Sequence[OpSchema]: ...
