set(gloo_DEPENDENCY_LIBS "")
set(gloo_cuda_DEPENDENCY_LIBS "")

# Configure path to modules (for find_package)
set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} "${PROJECT_SOURCE_DIR}/cmake/Modules/")

if(USE_REDIS)
  find_package(hiredis REQUIRED)
  if(HIREDIS_FOUND)
    include_directories(SYSTEM ${HIREDIS_INCLUDE_DIRS})
    list(APPEND gloo_DEPENDENCY_LIBS ${HIREDIS_LIBRARIES})
  else()
    message(WARNING "Not compiling with Redis support. Suppress this warning with -DUSE_REDIS=OFF.")
    set(USE_REDIS OFF)
  endif()
endif()

if(USE_IBVERBS)
  find_package(ibverbs REQUIRED)
  if(IBVERBS_FOUND)
    include_directories(SYSTEM ${IBVERBS_INCLUDE_DIRS})
    list(APPEND gloo_DEPENDENCY_LIBS ${IBVERBS_LIBRARIES})
  else()
    message(WARNING "Not compiling with ibverbs support. Suppress this warning with -DUSE_IBVERBS=OFF.")
    set(USE_IBVERBS OFF)
  endif()
endif()

if(USE_MPI)
  find_package(MPI)
  if(MPI_C_FOUND)
    message(STATUS "MPI include path: " ${MPI_CXX_INCLUDE_PATH})
    message(STATUS "MPI libraries: " ${MPI_CXX_LIBRARIES})
    include_directories(SYSTEM ${MPI_CXX_INCLUDE_PATH})
    list(APPEND gloo_DEPENDENCY_LIBS ${MPI_CXX_LIBRARIES})
    add_definitions(-DGLOO_USE_MPI=1)
  else()
    message(WARNING "Not compiling with MPI support. Suppress this warning with -DUSE_MPI=OFF.")
    set(USE_MPI OFF)
  endif()
endif()

if(USE_CUDA)
  include(cmake/Cuda.cmake)
  if(NOT HAVE_CUDA)
    message(WARNING "Not compiling with CUDA support. Suppress this warning with -DUSE_CUDA=OFF.")
    set(USE_CUDA OFF)
  endif()
endif()

if(USE_CUDA AND USE_NCCL)
  # NCCL_EXTERNAL is set if using the Caffe2 bundled version of NCCL
  if(NCCL_EXTERNAL)
    include_directories(SYSTEM ${NCCL_INCLUDE_DIRS})
    list(APPEND gloo_cuda_DEPENDENCY_LIBS ${NCCL_LIBRARIES} dl rt)
  else()
    find_package(nccl REQUIRED)
    if(NCCL_FOUND)
      include_directories(SYSTEM ${NCCL_INCLUDE_DIRS})
      list(APPEND gloo_cuda_DEPENDENCY_LIBS ${NCCL_LIBRARIES} dl rt)
    else()
      message(WARNING "Not compiling with NCCL support. Suppress this warning with -DUSE_NCCL=OFF.")
      set(USE_NCCL OFF)
    endif()
  endif()
endif()

# Make sure we can find googletest if building the tests
if(BUILD_TEST)
  # If the gtest target is already defined, we assume upstream knows
  # what they are doing and the version is new enough.
  if(NOT TARGET gtest)
    find_package(GTest REQUIRED)
    if(NOT GTEST_FOUND)
      message(FATAL_ERROR "Could not find googletest; cannot compile tests")
    endif()
    add_library(gtest INTERFACE)
    target_include_directories(gtest INTERFACE ${GTEST_INCLUDE_DIRS})
    target_link_libraries(gtest INTERFACE ${GTEST_LIBRARIES})
  endif()
endif()
