#!/usr/bin/env bash

# Copyright 2019 The MixMatch Authors.  All rights reserved.

echo "# MixMatch on large models (26M parameters) for CIFAR10 and CIFAR100"
common_args='--train_dir experiments/large --wd=0.04 --beta=0.75 --filters=135'
for seed in 1 2 3 4 5; do
    echo "python mixmatch.py --dataset=cifar10.${seed}@4000-1 --w_match=75 $common_args"
    echo "python mixmatch.py --dataset=cifar100.${seed}@10000-1 --w_match=150 $common_args"
done

