function y_vis = sim_pred(design,N)
%simulate Newey Powell problem, return y_vis for kernel ridge

% simulate data for this design
[f,sim,x_vis,~]=get_design(design);
[x,y,z]=sim(f,N);

% precalculate all kernel matrices
df=get_K(x,y,z,x_vis);

% initialize hyperparameters for tuning
lambda0=log(0.05);

% tuning by CV
kernel_ridge_obj=@(lambda) kernel_ridge_cv(df,exp(lambda)); %exp to ensure pos
lambda_star=fminunc(kernel_ridge_obj,lambda0);

% evaluate on full sample using tuned hyperparameters
y_vis=kernel_ridge_pred(df,exp(lambda_star),3); %exp to ensure pos

end

