#!/bin/bash
mems=(20 50 100)
n_iters=1
bs=10
runs=20
val=0
name=MNIST


python baselines_main.py --lr 0.05 --n_epochs 5 --samples_per_task 1000 --dataset split_mnist --validation $val --n_runs $runs --n_iters $n_iters --name "$name iid_training"
python cer_main.py --lr 0.05 --samples_per_task 1000 --dataset split_mnist --validation $val --rehearsal 0 --n_runs $runs --n_iters $n_iters --name "$name single"

for mem in "${mems[@]}"
    do
        python cer_main.py --lr 0.05 --samples_per_task 1000 --dataset split_mnist --validation $val --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --name "$name baseline"
        python cer_main.py --lr 0.05 --samples_per_task 1000 --dataset split_mnist --validation $val --subsample 50 --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --max_loss --compare_to_old_logits --name "$name max_loss_logit"
        python cer_main.py --lr 0.05 --samples_per_task 1000 --dataset split_mnist --validation $val --subsample 50 --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --max_loss --name "$name max_loss"
    done

